/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcVfCodeSendBusiService;
import com.tydic.umc.busi.bo.UmcVfCodeSendBusiReqBO;
import com.tydic.umc.busi.bo.UmcVfCodeSendBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.VfCodeMapper;
import com.tydic.umc.external.notice.bo.UmcExternalCallHttpSendMassageReqBO;
import com.tydic.umc.external.notice.bo.UmcExternalCallHttpSendMassageRspBO;
import com.tydic.umc.facde.NoticeServiceHolder;
import com.tydic.umc.po.VfCodePO;
import com.tydic.umc.util.UmcBusinessException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="umcVFCodeSendBusiService")
public class UmcVfCodeSendBusiServiceImpl
implements UmcVfCodeSendBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcVfCodeSendBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String COMMON_MSG = "\u6267\u884c\u968f\u673a\u7801\u53d1\u9001\u4e1a\u52a1\u670d\u52a1";
    private static final Integer SEND_MSG_INTERVAL_TIME = 60;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private VfCodeMapper vfCodeMapper;
    @Autowired
    private NoticeServiceHolder noticeServiceHolder;
    @Value(value="${isSendMsg}")
    private boolean isSendMsg;
    @Value(value="${IS_SHOW_VFCODE:true}")
    private boolean IS_SHOW_VFCODE;
    @Value(value="${vfCodeExpTime}")
    private Integer vfCodeExpTime;
    @Value(value="${sendVfCodeTemplateId}")
    private Long sendVfCodeTemplateId;

    @Autowired
    public UmcVfCodeSendBusiServiceImpl(VfCodeMapper vfCodeMapper) {
        this.vfCodeMapper = vfCodeMapper;
    }

    public UmcVfCodeSendBusiRspBO sendVfCode(UmcVfCodeSendBusiReqBO umcVfCodeSendBusiReqBO) {
        String oldVfCode;
        UmcVfCodeSendBusiRspBO rspBO = new UmcVfCodeSendBusiRspBO();
        rspBO.setRespCode("0000");
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u968f\u673a\u7801\u53d1\u9001\u4e1a\u52a1\u670d\u52a1\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)umcVfCodeSendBusiReqBO);
        }
        if (umcVfCodeSendBusiReqBO.getValidTime() == null || umcVfCodeSendBusiReqBO.getValidTime() == 0) {
            umcVfCodeSendBusiReqBO.setValidTime(this.vfCodeExpTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)(oldVfCode = this.judgeIsExistAvailableVfCode(umcVfCodeSendBusiReqBO.getRegMobile())))) {
            rspBO.setRespCode("2001");
            rspBO.setRespDesc("\u4e0a\u6b21\u77ed\u4fe1\u53d1\u9001\u540e\u8fd8\u672a\u8d85\u8fc71\u5206\u949f\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u7533\u8bf7");
            return rspBO;
        }
        String vFCode = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, 6);
        UmcVfCodeSendBusiRspBO createRspBO = this.createNewVfCodeAndSave(umcVfCodeSendBusiReqBO, vFCode);
        if (createRspBO != null) {
            return rspBO;
        }
        if (this.isSendMsg) {
            this.sendSms(umcVfCodeSendBusiReqBO.getRegMobile(), vFCode);
        }
        if (this.IS_SHOW_VFCODE) {
            rspBO.setVfCode(vFCode);
        }
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        return rspBO;
    }

    private String judgeIsExistAvailableVfCode(String regMobile) {
        boolean compareResult;
        String oldVfCode = null;
        VfCodePO vfCodeModel = new VfCodePO();
        vfCodeModel.setAccNbr(regMobile);
        vfCodeModel.setState(UmcEnumConstant.VfCodeState.NO_VALID.getCode());
        VfCodePO vfCodePO = this.vfCodeMapper.getModelByCondition(vfCodeModel);
        if (vfCodePO == null) {
            return null;
        }
        Date sysCurrentTime = new Date();
        Date intervalTime = this.buildExpOrIntervalTime(vfCodePO.getCreateTime(), SEND_MSG_INTERVAL_TIME);
        boolean bl = compareResult = sysCurrentTime.getTime() > intervalTime.getTime();
        if (compareResult) {
            vfCodePO.setState(UmcEnumConstant.VfCodeState.EXPIRED.getCode());
            int updateResult = this.vfCodeMapper.updateByCondition(vfCodePO);
            if (updateResult < 1) {
                throw new UmcBusinessException("2001", "\u66f4\u65b0\u8fc7\u671f\u968f\u673a\u7801\u72b6\u6001\u5931\u8d25");
            }
        } else {
            oldVfCode = vfCodePO.getVfCode();
        }
        return oldVfCode;
    }

    private UmcVfCodeSendBusiRspBO createNewVfCodeAndSave(UmcVfCodeSendBusiReqBO umcVfCodeSendBusiReqBO, String vFCode) {
        UmcVfCodeSendBusiRspBO rspBO = null;
        Date createTime = new Date();
        Date expTime = this.buildExpOrIntervalTime(createTime, umcVfCodeSendBusiReqBO.getValidTime());
        VfCodePO insertVfCodePO = new VfCodePO();
        insertVfCodePO.setAccNbr(umcVfCodeSendBusiReqBO.getRegMobile());
        insertVfCodePO.setVfCode(vFCode);
        insertVfCodePO.setState(UmcEnumConstant.VfCodeState.NO_VALID.getCode());
        insertVfCodePO.setCreateTime(createTime);
        insertVfCodePO.setExpTime(expTime);
        insertVfCodePO.setVfId(Sequence.getInstance().nextId());
        int insertResult = this.vfCodeMapper.insert(insertVfCodePO);
        if (insertResult < 1) {
            rspBO = new UmcVfCodeSendBusiRspBO();
            rspBO.setRespCode("2001");
            rspBO.setRespDesc("\u6267\u884c\u968f\u673a\u7801\u53d1\u9001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25! \u539f\u56e0:\u65b0\u968f\u673a\u7801\u4fdd\u5b58\u5230\u5e93\u5931\u8d25.");
        }
        return rspBO;
    }

    private String createVfCode() {
        String choiceSource = "0123456789";
        Integer randomDigitNum = 6;
        Object random = null;
        LOGGER.debug("\u6267\u884c\u968f\u673a\u7801\u53d1\u9001\u4e1a\u52a1\u670d\u52a1createVfCode-1" + choiceSource);
        String verifyCode = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, randomDigitNum);
        return verifyCode;
    }

    private Date buildExpOrIntervalTime(Date sysCurrentTime, Integer validTime) {
        Long currentTimeInMillis;
        String strCurrentDate = DateUtils.dateToStrLong((Date)sysCurrentTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            currentTimeInMillis = simpleDateFormat.parse(strCurrentDate).getTime();
        }
        catch (Exception e) {
            Calendar currentCalendar = Calendar.getInstance();
            currentTimeInMillis = currentCalendar.getTimeInMillis();
        }
        Long newTimeInMillis = currentTimeInMillis + (long)validTime.intValue() * 1000L;
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTimeInMillis(newTimeInMillis);
        return newCalendar.getTime();
    }

    private void sendSms(String mobile, String vFCode) {
        String content = "\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff1a" + vFCode;
        UmcExternalCallHttpSendMassageReqBO reqBO = new UmcExternalCallHttpSendMassageReqBO();
        reqBO.setMobile(mobile);
        reqBO.setContent(content);
        UmcExternalCallHttpSendMassageRspBO rspBO = this.noticeServiceHolder.getUmcExternalCallHttpSendMassageService().callHttpSendMassage(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
    }
}

