/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.busi.UmcBestPayCertCacheCheckBusiService;
import com.tydic.umc.comb.UmcBestPayCheckFirstLoginCombService;
import com.tydic.umc.comb.bo.UmcBestPayCheckFirstLoginCombReqBO;
import com.tydic.umc.comb.bo.UmcBestPayCheckFirstLoginCombRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.ThirdBindMapper;
import com.tydic.umc.external.bestpay.bo.UmcExternalBestPayEncryptInfoBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetTokenForBestPayReqBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetTokenForBestPayRspBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetUserBaseInfoForBestPayReqBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetUserBaseInfoForBestPayRspBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetUserMobileForBestPayReqBO;
import com.tydic.umc.external.bestpay.bo.UmcExternalGetUserMobileForBestPayRspBO;
import com.tydic.umc.facde.BestPayServiceHolder;
import com.tydic.umc.po.ThirdBindPO;
import com.tydic.umc.util.UmcBusinessException;
import java.io.File;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="umcBestPayCheckFirstLoginCombService")
public class UmcBestPayCheckFirstLoginCombServiceImpl
implements UmcBestPayCheckFirstLoginCombService {
    @Value(value="${BEST_PAY_CLIENTID}")
    private String BEST_PAY_CLIENTID;
    @Value(value="${BEST_PAY_VERSION}")
    private String BEST_PAY_VERSION;
    @Autowired
    private BestPayServiceHolder bestPayServiceHolder;
    @Autowired
    private ThirdBindMapper thirdBindMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UmcBestPayCertCacheCheckBusiService umcBestPayCertCacheCheckBusiService;

    public UmcBestPayCheckFirstLoginCombRspBO checkFirstLogin(UmcBestPayCheckFirstLoginCombReqBO reqBO) {
        UmcBestPayCheckFirstLoginCombRspBO rspBO = new UmcBestPayCheckFirstLoginCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFirstLogin(Boolean.valueOf(false));
        UmcExternalGetTokenForBestPayReqBO umcExternalGetTokenForBestPayReqBO = new UmcExternalGetTokenForBestPayReqBO();
        umcExternalGetTokenForBestPayReqBO.setAuthCode(reqBO.getJsCode());
        umcExternalGetTokenForBestPayReqBO.setGrantType("AUTH_CODE");
        umcExternalGetTokenForBestPayReqBO.setVersion(this.BEST_PAY_VERSION);
        umcExternalGetTokenForBestPayReqBO.setClientId(this.BEST_PAY_CLIENTID);
        umcExternalGetTokenForBestPayReqBO.setTimestamp(this.getTimestamp());
        umcExternalGetTokenForBestPayReqBO.setTraceLogId(this.generateTraceLogId());
        UmcExternalBestPayEncryptInfoBO umcExternalBestPayEncryptInfoBO = new UmcExternalBestPayEncryptInfoBO();
        this.createEncryptInfoBO(umcExternalBestPayEncryptInfoBO, reqBO);
        umcExternalGetTokenForBestPayReqBO.setUmcExternalBestPayEncryptInfoBO(umcExternalBestPayEncryptInfoBO);
        UmcExternalGetTokenForBestPayRspBO umcExternalGetTokenForBestPayRspBO = this.bestPayServiceHolder.getUmcExternalGetTokenForBestPayService().getTokenForBestPay(umcExternalGetTokenForBestPayReqBO);
        if (!umcExternalGetTokenForBestPayRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException("8888", umcExternalGetTokenForBestPayRspBO.getRespDesc());
        }
        ThirdBindPO thirdBindPOReq = new ThirdBindPO();
        thirdBindPOReq.setAuthId(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getOpenId());
        thirdBindPOReq.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        thirdBindPOReq.setAuthType(reqBO.getThirdAuthType());
        ThirdBindPO thirdBindPORsp = this.thirdBindMapper.getModelByCondition(thirdBindPOReq);
        if (null != thirdBindPORsp) {
            return rspBO;
        }
        rspBO.setFirstLogin(Boolean.valueOf(true));
        String accesToken = umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getAccessToken();
        String openId = umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getOpenId();
        UmcExternalGetUserBaseInfoForBestPayReqBO umcExternalGetUserBaseInfoForBestPayReqBO = new UmcExternalGetUserBaseInfoForBestPayReqBO();
        umcExternalGetUserBaseInfoForBestPayReqBO.setAccessToken(accesToken);
        umcExternalGetUserBaseInfoForBestPayReqBO.setOpenId(openId);
        umcExternalGetUserBaseInfoForBestPayReqBO.setClientId(this.BEST_PAY_CLIENTID);
        umcExternalGetUserBaseInfoForBestPayReqBO.setVersion(this.BEST_PAY_VERSION);
        umcExternalGetUserBaseInfoForBestPayReqBO.setScope("user_info");
        umcExternalGetUserBaseInfoForBestPayReqBO.setTimestamp(this.getTimestamp());
        umcExternalGetUserBaseInfoForBestPayReqBO.setTraceLogId(this.generateTraceLogId());
        umcExternalGetUserBaseInfoForBestPayReqBO.setUmcExternalBestPayEncryptInfoBO(umcExternalBestPayEncryptInfoBO);
        UmcExternalGetUserBaseInfoForBestPayRspBO umcExternalGetUserBaseInfoForBestPayRspBO = this.bestPayServiceHolder.getUmcExternalGetUserBaseInfoForBestPayService().getUserBaseInfoForBest(umcExternalGetUserBaseInfoForBestPayReqBO);
        if (!umcExternalGetUserBaseInfoForBestPayRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException("8888", umcExternalGetUserBaseInfoForBestPayRspBO.getRespDesc());
        }
        UmcExternalGetUserMobileForBestPayReqBO umcExternalGetUserMobileForBestPayReqBO = new UmcExternalGetUserMobileForBestPayReqBO();
        umcExternalGetUserMobileForBestPayReqBO.setAccessToken(accesToken);
        umcExternalGetUserMobileForBestPayReqBO.setOpenId(openId);
        umcExternalGetUserMobileForBestPayReqBO.setClientId(this.BEST_PAY_CLIENTID);
        umcExternalGetUserMobileForBestPayReqBO.setVersion(this.BEST_PAY_VERSION);
        umcExternalGetUserMobileForBestPayReqBO.setScope("mobile");
        umcExternalGetUserMobileForBestPayReqBO.setTimestamp(this.getTimestamp());
        umcExternalGetUserMobileForBestPayReqBO.setTraceLogId(this.generateTraceLogId());
        umcExternalGetUserMobileForBestPayReqBO.setUmcExternalBestPayEncryptInfoBO(umcExternalBestPayEncryptInfoBO);
        UmcExternalGetUserMobileForBestPayRspBO umcExternalGetUserMobileForBestPayRspBO = this.bestPayServiceHolder.getUmcExternalGetUserMobileForBestPayService().getUserMobileForBestPay(umcExternalGetUserMobileForBestPayReqBO);
        if (!umcExternalGetUserMobileForBestPayRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException("8888", umcExternalGetUserMobileForBestPayRspBO.getRespDesc());
        }
        rspBO.setOpenId(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getOpenId());
        rspBO.setAccessToken(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getAccessToken());
        rspBO.setExpiresIn(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getExpiresIn());
        rspBO.setRefExpiresIn(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getRefExpiresIn());
        rspBO.setRefreshToken(umcExternalGetTokenForBestPayRspBO.getUmcExternalWoPayTokenBO().getRefreshToken());
        rspBO.setHeadFile(umcExternalGetUserBaseInfoForBestPayRspBO.getUmcExternalWoPayUserBaseInfoBO().getHeadFile());
        rspBO.setNickName(umcExternalGetUserBaseInfoForBestPayRspBO.getUmcExternalWoPayUserBaseInfoBO().getNickName());
        rspBO.setMobile(umcExternalGetUserMobileForBestPayRspBO.getUmcExternalBestPayMobileBO().getMobile());
        return rspBO;
    }

    private String generateTraceLogId() {
        return DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss") + System.currentTimeMillis() % 10000000000L;
    }

    private String getTimestamp() {
        return DateUtils.dateToStrLong((Date)new Date());
    }

    private void createEncryptInfoBO(UmcExternalBestPayEncryptInfoBO encryptInfoBO, UmcBestPayCheckFirstLoginCombReqBO reqBO) {
        Object objIV = this.cacheClient.get(reqBO.getOrgId() + "_" + "BEST_PAY_AES_IV");
        Object objMerchantCode = this.cacheClient.get(reqBO.getOrgId() + "_" + "BEST_PAY_MERCHANT_CODE");
        Object objPwd = this.cacheClient.get(reqBO.getOrgId() + "_" + "BEST_PAY_CERT_PWD");
        Object objPriKeyFile = this.cacheClient.get(reqBO.getOrgId() + "_" + "BEST_PAY_CERT_P12");
        Object objPubKeyFile = this.cacheClient.get(reqBO.getOrgId() + "_" + "BEST_PAY_CERT_CER");
        if (null == objIV || null == objMerchantCode || null == objPwd || null == objPriKeyFile || null == objPubKeyFile) {
            this.umcBestPayCertCacheCheckBusiService.certCacheCheck();
        }
        encryptInfoBO.setMerchantCode(objMerchantCode.toString());
        encryptInfoBO.setAesIv(objIV.toString());
        encryptInfoBO.setCertPwd(objPwd.toString());
        encryptInfoBO.setPriKeyFile((File)objPriKeyFile);
        encryptInfoBO.setPubKeyFile((File)objPubKeyFile);
    }
}

