/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.tydic.umc.busi.UmcChangeIntegralStateBusiService;
import com.tydic.umc.busi.bo.UmcChangeIntegralStateBusiReqBO;
import com.tydic.umc.busi.bo.UmcChangeIntegralStateBusiRspBO;
import com.tydic.umc.comb.UmcDealExpIntegralTimingTaskCombService;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.dao.UmcDicDictionaryMapper;
import com.tydic.umc.po.DicDictionaryPO;
import com.tydic.umc.po.IntegralPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcDealExpIntegralTimingTaskCombService")
public class UmcDealExpIntegralTimingTaskCombServiceImpl
implements UmcDealExpIntegralTimingTaskCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcDealExpIntegralTimingTaskCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private IntegralMapper integralMapper;
    private UmcDicDictionaryMapper dicDictionaryMapper;
    private UmcChangeIntegralStateBusiService umcChangeIntegralStateBusiService;

    @Autowired
    public UmcDealExpIntegralTimingTaskCombServiceImpl(IntegralMapper integralMapper, UmcDicDictionaryMapper dicDictionaryMapper, UmcChangeIntegralStateBusiService umcChangeIntegralStateBusiService) {
        this.integralMapper = integralMapper;
        this.dicDictionaryMapper = dicDictionaryMapper;
        this.umcChangeIntegralStateBusiService = umcChangeIntegralStateBusiService;
    }

    public void execute(String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u4f1a\u5458\u4e2d\u5fc3\u8fc7\u671f\u79ef\u5206\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u5f00\u59cb=================");
        }
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setPCode("_totalShardCount");
        dicDictionaryModel.setCode("_totalShardCount");
        DicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (dicDictionaryPO == null) {
            if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
                LOGGER.info("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u5206\u7247\u503c");
            }
            return;
        }
        List<IntegralPO> integralPOS = this.integralMapper.getListByModId(dicDictionaryPO.getTitle(), currentShardValue);
        if (integralPOS == null || integralPOS.isEmpty()) {
            LOGGER.error("\u79ef\u5206\u8868\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (IntegralPO po : integralPOS) {
            UmcChangeIntegralStateBusiReqBO umcChangeIntegralStateBusiReqBO = new UmcChangeIntegralStateBusiReqBO();
            umcChangeIntegralStateBusiReqBO.setMemId(po.getMemId());
            umcChangeIntegralStateBusiReqBO.setIntId(po.getIntId());
            umcChangeIntegralStateBusiReqBO.setState(UmcEnumConstant.State.INVALID.getCode());
            UmcChangeIntegralStateBusiRspBO umcChangeIntegralStateBusiRspBO = this.umcChangeIntegralStateBusiService.changeState(umcChangeIntegralStateBusiReqBO);
            if (!IS_INFO_ENABLED && !IS_DEBUG_ENABLED) continue;
            LOGGER.info("{}", (Object)umcChangeIntegralStateBusiRspBO);
        }
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u4f1a\u5458\u4e2d\u5fc3\u8fc7\u671f\u79ef\u5206\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u7ed3\u675f=================");
        }
    }
}

