/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcEnterpriseOrgManageBusiService;
import com.tydic.umc.busi.UmcMemChangePozitionBusiService;
import com.tydic.umc.busi.UmcMemInfoUpdateBusiService;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgBusiBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgDetailBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemChangePozitionBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemChangePozitionBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemInfoUpdateBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemInfoUpdateBusiRspBO;
import com.tydic.umc.comb.UmcMemChangePozitionCombService;
import com.tydic.umc.comb.bo.UmcMemChangePozitionCombReqBO;
import com.tydic.umc.comb.bo.UmcMemChangePozitionCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.ChangePozitionHisMapper;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.external.authority.bo.UmcAuthorityAddUserReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityChangeLoginNameWebReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityChangeLoginNameWebRspBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityCopyPwdToOthersReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityCopyPwdToOthersRspBO;
import com.tydic.umc.external.authority.bo.UmcUpateAuthorityUserRspBO;
import com.tydic.umc.facde.AuthorityServiceHolder;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemChangePozitionCombService")
public class UmcMemChangePozitionCombServiceImpl
implements UmcMemChangePozitionCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemChangePozitionCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLE = LOGGER.isDebugEnabled();
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private UmcMemInfoUpdateBusiService umcMemInfoUpdateBusiService;
    @Autowired
    private UmcEnterpriseOrgManageBusiService umcEnterpriseOrgManageBusiService;
    @Autowired
    private AuthorityServiceHolder authorityServiceHolder;
    @Autowired
    private UmcMemChangePozitionBusiService umcMemChangePozitionBusiService;
    @Autowired
    private MemUserMapper memUserMapper;
    @Resource(name="regAccountSequencePager")
    private OrderSequence regAccountSequencePager;
    @Autowired
    private ChangePozitionHisMapper changePozitionHisMapper;

    public UmcMemChangePozitionCombRspBO submitMemChangePozition(UmcMemChangePozitionCombReqBO combReqBO) {
        UmcMemChangePozitionCombRspBO rsp = new UmcMemChangePozitionCombRspBO();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(combReqBO.getMemId());
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            throw new UmcBusinessException("8888", "\u4e0d\u5b58\u5728\u8be5\u4f1a\u5458\u4fe1\u606f\uff01");
        }
        if ("01".equals(member.getMemClassify())) {
            throw new UmcBusinessException("8888", "\u517c\u804c\u4f1a\u5458\u4e0d\u5141\u8bb8\u505a\u8c03\u5c97\u64cd\u4f5c\uff01");
        }
        if ("02".equals(member.getMemClassify())) {
            throw new UmcBusinessException("8888", "\u8c03\u5c97\u4f1a\u5458\u4e0d\u5141\u8bb8\u505a\u8c03\u5c97\u64cd\u4f5c\uff01");
        }
        Long randomNumber = this.getRegAccountSequencePager();
        String newRegAccount = member.getRegAccount() + "_" + randomNumber;
        MemUserPO memUserPO = new MemUserPO();
        memUserPO.setMemId(combReqBO.getMemId());
        memUserPO.setStatus("00");
        MemUserPO memUser = this.memUserMapper.getModelBy(memUserPO);
        if (null == memUser) {
            throw new UmcBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u7528\u6237\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        UmcAuthorityChangeLoginNameWebRspBO umcAuthorityChangeLoginNameWebRspBO = this.changeUserName(memUser.getUsreId(), newRegAccount);
        if (!"0000".equals(umcAuthorityChangeLoginNameWebRspBO.getRespCode())) {
            throw new UmcBusinessException(umcAuthorityChangeLoginNameWebRspBO.getRespCode(), umcAuthorityChangeLoginNameWebRspBO.getRespDesc());
        }
        MemberPO memMobilize = new MemberPO();
        memMobilize.setOrgId(combReqBO.getTargetOrgId());
        memMobilize.setMainMemId(member.getMainMemId());
        MemberPO memChangeJob = this.memberMapper.getModelByMobilize(memMobilize);
        if (memChangeJob != null) {
            UmcMemInfoUpdateBusiReqBO umcMemInfoUpdateBusiReqBO = new UmcMemInfoUpdateBusiReqBO();
            umcMemInfoUpdateBusiReqBO.setMemId(memChangeJob.getMemId());
            umcMemInfoUpdateBusiReqBO.setState(UmcCommConstant.MemState.EFFECTIVE);
            umcMemInfoUpdateBusiReqBO.setRegAccount(member.getRegAccount());
            umcMemInfoUpdateBusiReqBO.setMemClassify("00");
            UmcMemInfoUpdateBusiReqBO umcMemInfoUpdateBusiReqBO2 = new UmcMemInfoUpdateBusiReqBO();
            umcMemInfoUpdateBusiReqBO2.setMemId(combReqBO.getMemId());
            umcMemInfoUpdateBusiReqBO2.setRegAccount(member.getRegAccount() + "-" + randomNumber);
            umcMemInfoUpdateBusiReqBO2.setMemClassify("02");
            ArrayList<UmcMemInfoUpdateBusiReqBO> busiReqBOS = new ArrayList<UmcMemInfoUpdateBusiReqBO>();
            busiReqBOS.add(umcMemInfoUpdateBusiReqBO);
            busiReqBOS.add(umcMemInfoUpdateBusiReqBO2);
            UmcMemInfoUpdateBusiRspBO umcMemInfoUpdateBusiRspBO = this.umcMemInfoUpdateBusiService.updateBatchMemInfo(busiReqBOS);
            if (!"0000".equals(umcMemInfoUpdateBusiRspBO.getRespCode())) {
                throw new UmcBusinessException(umcMemInfoUpdateBusiRspBO.getRespCode(), umcMemInfoUpdateBusiRspBO.getRespDesc());
            }
            UmcAuthorityChangeLoginNameWebRspBO authorityChangeLoginNameWebRspBO = this.changeUserName(memChangeJob.getUserId(), member.getRegAccount());
            if (!"0000".equals(authorityChangeLoginNameWebRspBO.getRespCode())) {
                throw new UmcBusinessException(authorityChangeLoginNameWebRspBO.getRespCode(), authorityChangeLoginNameWebRspBO.getRespDesc());
            }
            UmcAuthorityCopyPwdToOthersReqBO umcAuthorityCopyPwdToOthersReqBO = new UmcAuthorityCopyPwdToOthersReqBO();
            umcAuthorityCopyPwdToOthersReqBO.setUserIdReq(memUser.getUsreId());
            umcAuthorityCopyPwdToOthersReqBO.setOtherUserIdReq(memChangeJob.getUserId());
            UmcAuthorityCopyPwdToOthersRspBO umcAuthorityCopyPwdToOthersRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().copyPwdToOthers(umcAuthorityCopyPwdToOthersReqBO);
            if (!"0000".equals(umcAuthorityCopyPwdToOthersRspBO.getRespCode())) {
                throw new UmcBusinessException(umcAuthorityCopyPwdToOthersRspBO.getRespCode(), umcAuthorityCopyPwdToOthersRspBO.getRespDesc());
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u4f1a\u5458\u8c03\u5c97\u63d0\u4ea4\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
            return rsp;
        }
        Long userId = Sequence.getInstance().nextId();
        UmcAuthorityAddUserReqBO umcAuthorityAddUserReqBO = this.buildAddUserReqBO(member, userId, combReqBO.getTargetOrgId());
        UmcUpateAuthorityUserRspBO umcUpateAuthorityUserRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().invokeInsertUser(umcAuthorityAddUserReqBO);
        if (!"0000".equals(umcUpateAuthorityUserRspBO.getRespCode())) {
            throw new UmcBusinessException(umcUpateAuthorityUserRspBO.getRespCode(), umcUpateAuthorityUserRspBO.getRespDesc());
        }
        UmcAuthorityCopyPwdToOthersReqBO umcAuthorityCopyPwdToOthersReqBO = new UmcAuthorityCopyPwdToOthersReqBO();
        umcAuthorityCopyPwdToOthersReqBO.setUserIdReq(memUser.getUsreId());
        umcAuthorityCopyPwdToOthersReqBO.setOtherUserIdReq(userId);
        UmcAuthorityCopyPwdToOthersRspBO umcAuthorityCopyPwdToOthersRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().copyPwdToOthers(umcAuthorityCopyPwdToOthersReqBO);
        if (!"0000".equals(umcAuthorityCopyPwdToOthersRspBO.getRespCode())) {
            throw new UmcBusinessException(umcAuthorityCopyPwdToOthersRspBO.getRespCode(), umcAuthorityCopyPwdToOthersRspBO.getRespDesc());
        }
        String newMemRegAccount = member.getRegAccount() + "-" + randomNumber;
        UmcMemChangePozitionBusiReqBO umcMemChangePozitionBusiReqBO = new UmcMemChangePozitionBusiReqBO();
        umcMemChangePozitionBusiReqBO.setMemId(combReqBO.getMemId());
        umcMemChangePozitionBusiReqBO.setNewRegAccount(newMemRegAccount);
        umcMemChangePozitionBusiReqBO.setRemark(combReqBO.getRemark());
        umcMemChangePozitionBusiReqBO.setTargetOrgId(combReqBO.getTargetOrgId());
        umcMemChangePozitionBusiReqBO.setUserId(userId);
        UmcMemChangePozitionBusiRspBO umcMemChangePozitionBusiRspBO = this.umcMemChangePozitionBusiService.submitMemChangePozition(umcMemChangePozitionBusiReqBO);
        if (!"0000".equals(umcMemChangePozitionBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcMemChangePozitionBusiRspBO.getRespCode(), umcMemChangePozitionBusiRspBO.getRespDesc());
        }
        this.memberMapper.updateForMainMemId(combReqBO.getMemId(), umcMemChangePozitionBusiRspBO.getNewMemId());
        this.changePozitionHisMapper.updateForMemId(combReqBO.getMemId(), umcMemChangePozitionBusiRspBO.getNewMemId());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u8c03\u5c97\u63d0\u4ea4\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private UmcAuthorityChangeLoginNameWebRspBO changeUserName(Long userId, String newRegAccount) {
        UmcAuthorityChangeLoginNameWebReqBO umcAuthorityChangeLoginNameWebReqBO = new UmcAuthorityChangeLoginNameWebReqBO();
        umcAuthorityChangeLoginNameWebReqBO.setUserIdReq(userId);
        umcAuthorityChangeLoginNameWebReqBO.setLoginNameReq(newRegAccount);
        UmcAuthorityChangeLoginNameWebRspBO umcAuthorityChangeLoginNameWebRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().invokeChangeLoginName(umcAuthorityChangeLoginNameWebReqBO);
        return umcAuthorityChangeLoginNameWebRspBO;
    }

    private UmcAuthorityAddUserReqBO buildAddUserReqBO(MemberPO member, Long userId, Long targetOrgId) {
        UmcEnterpriseOrgBusiBO busiBO = new UmcEnterpriseOrgBusiBO();
        busiBO.setOrgId(targetOrgId);
        UmcEnterpriseOrgDetailBusiRspBO busiRspBO = this.umcEnterpriseOrgManageBusiService.queryEnterpriseOrgDetail(busiBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        UmcAuthorityAddUserReqBO bo = new UmcAuthorityAddUserReqBO();
        bo.setAuthUserId(userId);
        bo.setLoginNameReq(member.getRegAccount());
        bo.setNameReq(member.getMemName2());
        bo.setCellPhoneReq(member.getRegMobile());
        bo.setEmailReq(member.getRegEmail());
        bo.setType("auth:default:manage");
        bo.setTenantIdReq(busiRspBO.getUmcEnterpriseOrgBO().getTenantId());
        bo.setPasswordReq(member.getPasswd());
        bo.setOrgIdReq(targetOrgId);
        bo.setPassCreate(Integer.valueOf(2));
        return bo;
    }

    private long getRegAccountSequencePager() {
        try {
            return this.regAccountSequencePager.nextId();
        }
        catch (Exception e) {
            if (IS_DEBUG_ENABLE) {
                LOGGER.error("\u83b7\u53d66\u4f4d\u968f\u673a\u6570\u5f02\u5e38\uff1a");
                e.printStackTrace();
            }
            throw new UmcBusinessException("8888", "\u83b7\u53d6\u4f1a\u5458\u6635\u79f0ID\u5f02\u5e38", e);
        }
    }
}

