/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.DigestUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcMemRegistBusiService;
import com.tydic.umc.busi.bo.UmcMemRegistBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemRegistBusiRspBO;
import com.tydic.umc.comb.UmcMemImportTimingTaskCombService;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemberImpLogItemMapper;
import com.tydic.umc.dao.MemberImpLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.MemberImpLogItemPO;
import com.tydic.umc.po.MemberImpLogPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="umcMemImportTimingTaskCombService")
public class UmcMemImportTimingTaskCombServiceImpl
implements UmcMemImportTimingTaskCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemImportTimingTaskCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemberImpLogItemMapper memberImpLogItemMapper;
    @Autowired
    private MemberImpLogMapper memberImpLogMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private UmcMemRegistBusiService umcMemRegistBusiService;
    @Autowired
    private MemberMapper memberMapper;

    public void execute(String currentShardValue) {
        List<MemberImpLogPO> memberImpLogPOS = this.memberImpLogMapper.getListForMemImp(UmcCommConstant.MemberImpLogStatus.NOT_IMP);
        if (CollectionUtils.isEmpty(memberImpLogPOS)) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
            return;
        }
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        dicDictionaryBO.setPCode("MEMBER_IMP_SHARD_VALUE");
        dicDictionaryBO.setCode("MEMBER_IMP_SHARD_VALUE");
        DicDictionaryBO dicDictionary = this.dictionaryBusiService.getDictionaryByBO(dicDictionaryBO);
        if (null == dicDictionary) {
            LOGGER.info("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u5206\u7247\u503c");
            return;
        }
        String passwd = this.defaultPasswd();
        for (MemberImpLogPO memberImpLogPO : memberImpLogPOS) {
            MemberImpLogPO checkImpLogPO = this.memberImpLogMapper.getModelById(memberImpLogPO.getImpId());
            if (null == checkImpLogPO || !UmcCommConstant.MemberImpLogStatus.NOT_IMP.equals(checkImpLogPO.getImpStatus())) continue;
            this.updateStatus(memberImpLogPO.getImpId(), UmcCommConstant.MemberImpLogStatus.IMPING, null, null, null);
            List<MemberImpLogItemPO> memberImpLogItemPOS = this.memberImpLogItemMapper.getListByImpId(dicDictionary.getTitle(), currentShardValue, memberImpLogPO.getImpId().toString());
            Integer failCount = 0;
            Integer successCount = 0;
            Integer mobileRepeatCount = 0;
            if (!CollectionUtils.isEmpty(memberImpLogItemPOS)) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5f00\u59cb\u5faa\u73af\u6570\u636e");
                }
                for (MemberImpLogItemPO memberImpLogItemPO : memberImpLogItemPOS) {
                    int value;
                    List<MemberPO> memberPOS = this.checkMobile(memberImpLogItemPO.getMobile(), memberImpLogItemPO.getAdmOrgId());
                    if (!CollectionUtils.isEmpty(memberPOS)) {
                        MemberImpLogItemPO impLogItemPO = new MemberImpLogItemPO();
                        impLogItemPO.setImpResult(UmcCommConstant.MemberImpLogItemResult.FAIL);
                        impLogItemPO.setStatus(UmcCommConstant.MemberImpLogItemStatus.EXIST);
                        impLogItemPO.setImpItemId(memberImpLogItemPO.getImpItemId());
                        impLogItemPO.setRemark("\u5931\u8d25\u539f\u56e0\uff1a\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
                        this.memberImpLogItemMapper.updateByImpItemId(impLogItemPO);
                        Integer n = mobileRepeatCount;
                        Integer n2 = mobileRepeatCount = Integer.valueOf(mobileRepeatCount + 1);
                        continue;
                    }
                    if (IS_DEBUG_ENABLED) {
                        LOGGER.debug("\u624b\u673a\u53f7\u6821\u9a8c\u901a\u8fc7");
                    }
                    UmcMemRegistBusiReqBO umcMemRegistBusiReqBO = new UmcMemRegistBusiReqBO();
                    this.buildReqBO(umcMemRegistBusiReqBO, memberImpLogItemPO, passwd);
                    UmcMemRegistBusiRspBO UmcMemRegistBusiRspBO2 = this.umcMemRegistBusiService.dealMemRegist(umcMemRegistBusiReqBO);
                    MemberImpLogItemPO impLogItemPO = new MemberImpLogItemPO();
                    impLogItemPO.setImpItemId(memberImpLogItemPO.getImpItemId());
                    if ("0000".equals(UmcMemRegistBusiRspBO2.getRespCode())) {
                        impLogItemPO.setRemark(UmcMemRegistBusiRspBO2.getRespDesc());
                        impLogItemPO.setImpResult(UmcCommConstant.MemberImpLogItemResult.SUCCESS);
                        impLogItemPO.setStatus(UmcCommConstant.MemberImpLogItemStatus.EXIST);
                        Integer n = successCount;
                        Integer n3 = successCount = Integer.valueOf(successCount + 1);
                    } else {
                        impLogItemPO.setImpResult(UmcCommConstant.MemberImpLogItemResult.FAIL);
                        impLogItemPO.setStatus(UmcCommConstant.MemberImpLogItemStatus.NOT_EXIST);
                        impLogItemPO.setRemark("\u5931\u8d25\u539f\u56e0\uff1a" + UmcMemRegistBusiRspBO2.getRespDesc());
                    }
                    if (IS_DEBUG_ENABLED) {
                        LOGGER.debug("\u6ce8\u518c\u6210\u529f");
                    }
                    if ((value = this.memberImpLogItemMapper.updateByImpItemId(impLogItemPO)) >= 1 || !IS_DEBUG_ENABLED) continue;
                    LOGGER.debug("\u66f4\u65b0memberImpLogItemMapper\u5931\u8d25");
                }
                failCount = memberImpLogItemPOS.size() - successCount - mobileRepeatCount;
            }
            this.updateStatus(memberImpLogPO.getImpId(), UmcCommConstant.MemberImpLogStatus.IMP_FINISH, successCount, failCount, mobileRepeatCount);
        }
    }

    private void updateStatus(Long impId, Integer impStatus, Integer succCount, Integer failCount, Integer mobileRepeatCount) {
        MemberImpLogPO impLogPO = new MemberImpLogPO();
        impLogPO.setImpStatus(impStatus);
        impLogPO.setImpId(impId);
        impLogPO.setSuccessCount(succCount);
        impLogPO.setFailCount(failCount);
        impLogPO.setMobileRepeatCount(mobileRepeatCount);
        impLogPO.setUpdateTime(new Date());
        int value = this.memberImpLogMapper.updateByImpId(impLogPO);
        if (value < 1) {
            LOGGER.info("\u7528\u6237\u5bfc\u5165excel\u5b9a\u65f6\u4efb\u52a1\u66f4\u65b0\u72b6\u6001\u51fa\u73b0\u5f02\u5e38");
            return;
        }
    }

    private void buildReqBO(UmcMemRegistBusiReqBO reqBO, MemberImpLogItemPO memberImpLogItemPO, String passwd) {
        reqBO.setPasswd(DigestUtils.Encrypt((String)passwd, (String)"MD5"));
        reqBO.setRegMobile(memberImpLogItemPO.getMobile());
        reqBO.setMemName2(memberImpLogItemPO.getName());
        reqBO.setMemNickName(memberImpLogItemPO.getName());
        reqBO.setCertNo(memberImpLogItemPO.getCertId());
        reqBO.setCertType(UmcEnumConstant.CertType.ID_18.getCode());
        reqBO.setMemType(UmcCommConstant.MemType.NORMAL_MEM);
        reqBO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
        reqBO.setStopStatus("01");
        reqBO.setMemClassify("00");
        reqBO.setMemState(UmcCommConstant.MemState.EFFECTIVE);
        reqBO.setUsreIdWeb(Long.valueOf(Sequence.getInstance().nextId()));
        reqBO.setOrgIdWeb(memberImpLogItemPO.getAdmOrgId());
        reqBO.setMemAffiliation("00");
    }

    private List<MemberPO> checkMobile(String mobile, Long orgId) {
        MemberPO conditionPO = new MemberPO();
        conditionPO.setOrgId(orgId);
        conditionPO.setRegMobile(mobile);
        return this.memberMapper.getMemInfoByCondition(conditionPO);
    }

    private String defaultPasswd() {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        dicDictionaryBO.setPCode("DEFAULT_PWD");
        DicDictionaryBO dicDictionary = this.dictionaryBusiService.getDictionaryByBO(dicDictionaryBO);
        if (null == dicDictionary) {
            LOGGER.info("\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
            throw new UmcBusinessException("8888", "\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)dicDictionary.getCode())) {
            LOGGER.info("\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
            throw new UmcBusinessException("8888", "\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        return dicDictionary.getCode();
    }
}

