/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.busi.UmcMemCheckUserBusiService;
import com.tydic.umc.busi.UmcMemDetailQueryBusiService;
import com.tydic.umc.busi.UmcMemLoginBusiService;
import com.tydic.umc.busi.UmcMemQueryCreateBusiService;
import com.tydic.umc.busi.UmcMemRegistBusiService;
import com.tydic.umc.busi.UmcMultiCondQueryMemBusiService;
import com.tydic.umc.busi.UmcVfCodeCheckBusiService;
import com.tydic.umc.busi.bo.FaceInfoBusiBO;
import com.tydic.umc.busi.bo.MemberInfoBusiBO;
import com.tydic.umc.busi.bo.UmcMemCheckUserBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemCheckUserBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemLoginBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemLoginBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemQueryCreateBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemRegistBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemRegistBusiRspBO;
import com.tydic.umc.busi.bo.UmcMultiCondQueryMemBusiReqBO;
import com.tydic.umc.busi.bo.UmcMultiCondQueryMemBusiRspBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiReqBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiRspBO;
import com.tydic.umc.comb.UmcMemLoginCombService;
import com.tydic.umc.comb.bo.UmcMemLoginCombReqBO;
import com.tydic.umc.comb.bo.UmcMemLoginCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.util.RspUtils;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcMemLoginCombService")
public class UmcMemLoginCombServiceImpl
implements UmcMemLoginCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemLoginCombServiceImpl.class);
    private static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    private UmcMultiCondQueryMemBusiService umcMultiCondQueryMemBusiService;
    private UmcMemLoginBusiService umcMemLoginBusiService;
    private UmcMemRegistBusiService umcMemRegistBusiService;
    private UmcMemQueryCreateBusiService umcMemQueryCreateBusiService;
    private UmcVfCodeCheckBusiService umcVfCodeCheckBusiService;
    private UmcMemCheckUserBusiService umcMemCheckUserBusiService;
    @Autowired
    private UmcMemDetailQueryBusiService umcMemDetailQueryBusiService;
    @Autowired
    private CacheClient cacheService;

    @Autowired
    public UmcMemLoginCombServiceImpl(UmcMultiCondQueryMemBusiService umcMultiCondQueryMemBusiService, UmcMemLoginBusiService umcMemLoginBusiService, UmcMemRegistBusiService umcMemRegistBusiService, UmcMemQueryCreateBusiService umcMemQueryCreateBusiService, UmcVfCodeCheckBusiService umcVfCodeCheckBusiService, UmcMemCheckUserBusiService umcMemCheckUserBusiService) {
        this.umcMultiCondQueryMemBusiService = umcMultiCondQueryMemBusiService;
        this.umcMemLoginBusiService = umcMemLoginBusiService;
        this.umcMemRegistBusiService = umcMemRegistBusiService;
        this.umcMemQueryCreateBusiService = umcMemQueryCreateBusiService;
        this.umcVfCodeCheckBusiService = umcVfCodeCheckBusiService;
        this.umcMemCheckUserBusiService = umcMemCheckUserBusiService;
    }

    public UmcMemLoginCombRspBO dealMemLogin(UmcMemLoginCombReqBO reqBO) {
        UmcMemLoginCombRspBO rspBO = new UmcMemLoginCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5931\u8d25");
        this.queryMemberInfoBeforeBusiCheck(reqBO, rspBO);
        if (RspUtils.isNotSuccess((UmcRspBaseBO)rspBO)) {
            return rspBO;
        }
        UmcMultiCondQueryMemBusiReqBO queryMemBusiReqBO = this.buildQueryMemBusiReqBO(reqBO);
        UmcMultiCondQueryMemBusiRspBO queryMemBusiRspBO = this.umcMultiCondQueryMemBusiService.multiCondQueryMem(queryMemBusiReqBO);
        if (RspUtils.isNotSuccess((UmcRspBaseBO)queryMemBusiRspBO)) {
            if (!UmcEnumConstant.LoginType.PHONE.getCode().equals(reqBO.getLoginType())) {
                rspBO.setRespCode("3002");
                rspBO.setRespDesc("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            UmcMemRegistBusiReqBO registBusiReqBO = new UmcMemRegistBusiReqBO();
            registBusiReqBO.setRegMobile(reqBO.getRegMobile());
            registBusiReqBO.setThirdAuthType(reqBO.getThirdAuthType());
            registBusiReqBO.setThirdAuthId(reqBO.getThirdAuthId());
            registBusiReqBO.setMemType(UmcEnumConstant.MemType.NORMAL.getCode());
            registBusiReqBO.setOrgIdWeb(reqBO.getOrgId());
            registBusiReqBO.setMemAffiliation("00");
            registBusiReqBO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
            registBusiReqBO.setStopStatus("01");
            boolean isEmpty = StringUtils.isEmpty((Object)reqBO.getFaceId());
            if (!isEmpty) {
                ArrayList<FaceInfoBusiBO> faceInfoList = new ArrayList<FaceInfoBusiBO>(4);
                FaceInfoBusiBO faceInfoBusiBO = new FaceInfoBusiBO();
                faceInfoBusiBO.setFaceId(reqBO.getFaceId());
                faceInfoList.add(faceInfoBusiBO);
                registBusiReqBO.setFaceInfoList(faceInfoList);
            }
            UmcMultiCondQueryMemBusiReqBO umcMultiCondQueryMemBusiReqBO = new UmcMultiCondQueryMemBusiReqBO();
            umcMultiCondQueryMemBusiReqBO.setRegMobile(registBusiReqBO.getRegMobile());
            umcMultiCondQueryMemBusiReqBO.setState(UmcCommConstant.MemState.EFFECTIVE);
            umcMultiCondQueryMemBusiReqBO.setOrgId(reqBO.getOrgId());
            queryMemBusiRspBO = this.umcMultiCondQueryMemBusiService.multiCondQueryMem(umcMultiCondQueryMemBusiReqBO);
            if (RspUtils.isSuccess((UmcRspBaseBO)queryMemBusiRspBO)) {
                throw new UmcBusinessException("5001", "\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u88ab\u6ce8\u518c");
            }
            UmcMemRegistBusiRspBO registBusiRspBO = this.umcMemRegistBusiService.dealMemRegist(registBusiReqBO);
            UmcMemQueryCreateBusiReqBO createBusiReqBO = new UmcMemQueryCreateBusiReqBO();
            createBusiReqBO.setMemId(registBusiRspBO.getMemId());
            createBusiReqBO.setQryType(UmcEnumConstant.QryType.REG_MOBILE.getCode());
            createBusiReqBO.setQryCond(registBusiReqBO.getRegMobile());
            this.umcMemQueryCreateBusiService.create(createBusiReqBO);
            umcMultiCondQueryMemBusiReqBO.setMemId(registBusiRspBO.getMemId());
            queryMemBusiRspBO = this.umcMultiCondQueryMemBusiService.multiCondQueryMem(umcMultiCondQueryMemBusiReqBO);
        }
        this.queryMemberInfoAfterBusiCheck(reqBO, queryMemBusiRspBO, rspBO);
        if (RspUtils.isNotSuccess((UmcRspBaseBO)rspBO)) {
            return rspBO;
        }
        Long memId = queryMemBusiRspBO.getMemberInfoBusiBO().getMemId();
        UmcMemLoginBusiReqBO loginBusiReqBO = new UmcMemLoginBusiReqBO();
        loginBusiReqBO.setLoginType(reqBO.getLoginType());
        loginBusiReqBO.setMemId(memId);
        UmcMemLoginBusiRspBO busiRspBO = this.umcMemLoginBusiService.dealMemLogin(loginBusiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        rspBO.setMemId(memId);
        rspBO.setJsessionId(busiRspBO.getJsessionId());
        rspBO.setOrgId(queryMemBusiRspBO.getMemberInfoBusiBO().getOrgId());
        rspBO.setRegMobile(queryMemBusiRspBO.getMemberInfoBusiBO().getRegMobile());
        rspBO.setMemLevel(queryMemBusiRspBO.getMemberInfoBusiBO().getMemLevel());
        rspBO.setMemNewOld(queryMemBusiRspBO.getMemberInfoBusiBO().getMemNewOld());
        this.saveJsessionId(busiRspBO.getJsessionId(), memId, reqBO.getPayTypeIn(), reqBO.getIsShopInterMem());
        return rspBO;
    }

    private void queryMemberInfoAfterBusiCheck(UmcMemLoginCombReqBO reqBO, UmcMultiCondQueryMemBusiRspBO queryMemBusiRspBO, UmcMemLoginCombRspBO rspBO) {
        MemberInfoBusiBO memberInfoBusiBO = queryMemBusiRspBO.getMemberInfoBusiBO();
        if (null != memberInfoBusiBO.getIsBlackList() && UmcEnumConstant.IsBlacklist.YES.getCode().equals(memberInfoBusiBO.getIsBlackList())) {
            rspBO.setRespCode("3003");
            rspBO.setRespDesc("\u9ed1\u540d\u5355\u4f1a\u5458");
            return;
        }
        if (UmcEnumConstant.LoginType.ACCOUNT.getCode().equals(reqBO.getLoginType()) && !Objects.equals(reqBO.getPasswd(), memberInfoBusiBO.getPasswd())) {
            rspBO.setRespCode("3004");
            rspBO.setRespDesc("\u767b\u5f55\u5bc6\u7801\u9519\u8bef");
        }
        if ("1".equals(reqBO.getAuthFlag())) {
            UmcMemCheckUserBusiReqBO umcMemCheckUserBusiReqBO = new UmcMemCheckUserBusiReqBO();
            umcMemCheckUserBusiReqBO.setMemId(memberInfoBusiBO.getMemId());
            UmcMemCheckUserBusiRspBO umcMemCheckUserBusiRspBO = this.umcMemCheckUserBusiService.memCheckUser(umcMemCheckUserBusiReqBO);
            queryMemBusiRspBO.getMemberInfoBusiBO().setUserId(umcMemCheckUserBusiRspBO.getUserId());
            if (!"0000".equals(umcMemCheckUserBusiRspBO.getRespCode())) {
                rspBO.setRespCode(umcMemCheckUserBusiRspBO.getRespCode());
                rspBO.setRespDesc(umcMemCheckUserBusiRspBO.getRespDesc());
            }
        }
    }

    private void queryMemberInfoBeforeBusiCheck(UmcMemLoginCombReqBO reqBO, UmcMemLoginCombRspBO rspBO) {
        if (UmcEnumConstant.LoginType.PHONE.getCode().equals(reqBO.getLoginType())) {
            UmcVfCodeCheckBusiReqBO checkReqBO = new UmcVfCodeCheckBusiReqBO();
            checkReqBO.setRegMobile(reqBO.getRegMobile());
            checkReqBO.setVFCode(reqBO.getRegVfCode());
            UmcVfCodeCheckBusiRspBO checkRspBO = this.umcVfCodeCheckBusiService.checkVfCode(checkReqBO);
            if (IS_DEBUG) {
                LOGGER.debug("\u9a8c\u8bc1\u7801\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)checkRspBO);
            }
            if (RspUtils.isNotSuccess((UmcRspBaseBO)checkRspBO)) {
                rspBO.setRespCode("3001");
                rspBO.setRespDesc("\u767b\u5f55\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff1a" + checkRspBO.getRespDesc());
            }
        }
    }

    private UmcMultiCondQueryMemBusiReqBO buildQueryMemBusiReqBO(UmcMemLoginCombReqBO reqBO) {
        UmcMultiCondQueryMemBusiReqBO queryReqBO = new UmcMultiCondQueryMemBusiReqBO();
        if (UmcEnumConstant.LoginType.PHONE.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setRegMobile(reqBO.getRegMobile());
        } else if (UmcEnumConstant.LoginType.FACE_ID.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setFaceId(reqBO.getFaceId());
        } else if (UmcEnumConstant.LoginType.THIRD_AUTH.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setAuthType(reqBO.getThirdAuthType());
            queryReqBO.setAuthId(reqBO.getThirdAuthId());
        } else if (UmcEnumConstant.LoginType.ACCOUNT.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setRegAccount(reqBO.getRegAccount());
        } else if (UmcEnumConstant.LoginType.SESSION.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setMemId(reqBO.getMemId());
            queryReqBO.setJsessionId(reqBO.getJsessionId());
        } else if (UmcEnumConstant.LoginType.VIRTUAL.getCode().equals(reqBO.getLoginType())) {
            queryReqBO.setRegAccount(reqBO.getRegAccount());
        }
        queryReqBO.setOrgId(reqBO.getOrgId());
        queryReqBO.setState(UmcCommConstant.MemState.EFFECTIVE);
        return queryReqBO;
    }

    private void saveJsessionId(String jsessionId, Long memId, Integer payTypeIn, String isShopInterMem) {
        UmcMemDetailQueryBusiReqBO reqBO = new UmcMemDetailQueryBusiReqBO();
        reqBO.setMemId(memId);
        UmcMemDetailQueryBusiRspBO rspBO = this.umcMemDetailQueryBusiService.memDetailQuery(reqBO);
        Object obj = this.cacheService.get("logIn_" + memId);
        if (obj != null) {
            this.cacheService.delete(String.valueOf(obj));
            this.cacheService.delete(memId + String.valueOf(obj));
        }
        this.cacheService.set("logIn_" + memId, (Object)jsessionId, 43200);
        this.cacheService.set(jsessionId, (Object)memId, 43200);
        rspBO.getUmcMemDetailInfoBusiRspBO().setPayTypeIn(payTypeIn);
        rspBO.getUmcMemDetailInfoBusiRspBO().setState(null);
        rspBO.getUmcMemDetailInfoBusiRspBO().setIsShopInterMem(isShopInterMem);
        this.cacheService.set(memId + jsessionId, (Object)rspBO.getUmcMemDetailInfoBusiRspBO(), 43200);
    }
}

