/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcEnterpriseOrgManageBusiService;
import com.tydic.umc.busi.UmcMemPartMemBusiService;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgBusiBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgDetailBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemPartMemBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemPartMemBusiRspBO;
import com.tydic.umc.comb.UmcMemPartMemCombService;
import com.tydic.umc.comb.bo.UmcMemPartMemCombReqBO;
import com.tydic.umc.comb.bo.UmcMemPartMemCombRspBO;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.external.authority.bo.UmcAuthorityAddUserReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityCopyPwdToOthersReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityCopyPwdToOthersRspBO;
import com.tydic.umc.external.authority.bo.UmcUpateAuthorityUserRspBO;
import com.tydic.umc.facde.AuthorityServiceHolder;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.util.UmcBusinessException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemPartMemCombService")
public class UmcMemPartMemCombServiceImpl
implements UmcMemPartMemCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemPartMemCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLE = LOGGER.isDebugEnabled();
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private UmcEnterpriseOrgManageBusiService umcEnterpriseOrgManageBusiService;
    @Autowired
    private AuthorityServiceHolder authorityServiceHolder;
    @Autowired
    private UmcMemPartMemBusiService umcMemPartMemBusiService;
    @Autowired
    private MemUserMapper memUserMapper;
    @Resource(name="regAccountSequencePager")
    private OrderSequence regAccountSequencePager;

    public UmcMemPartMemCombRspBO submitMemPartMem(UmcMemPartMemCombReqBO combReqBO) {
        UmcMemPartMemCombRspBO rsp = new UmcMemPartMemCombRspBO();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(combReqBO.getMemId());
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            throw new UmcBusinessException("8888", "\u4e0d\u5b58\u5728\u8be5\u4f1a\u5458\u4fe1\u606f\uff01");
        }
        if ("01".equals(member.getMemClassify())) {
            throw new UmcBusinessException("8888", "\u517c\u804c\u4f1a\u5458\u4e0d\u5141\u8bb8\u505a\u517c\u804c\u64cd\u4f5c\uff01");
        }
        if ("02".equals(member.getMemClassify())) {
            throw new UmcBusinessException("8888", "\u8c03\u5c97\u4f1a\u5458\u4e0d\u5141\u8bb8\u505a\u517c\u804c\u64cd\u4f5c\uff01");
        }
        String memberAccount = member.getRegAccount();
        for (Long orgId : combReqBO.getOrgIds()) {
            Long randomNumber = this.getRegAccountSequencePager();
            String newRegAccount = memberAccount + "-" + randomNumber;
            String newMemRegAccount = memberAccount + "-" + randomNumber;
            Long userId = Sequence.getInstance().nextId();
            member.setRegAccount(newRegAccount);
            UmcAuthorityAddUserReqBO umcAuthorityAddUserReqBO = this.buildAddUserReqBO(member, userId, orgId);
            UmcUpateAuthorityUserRspBO umcUpateAuthorityUserRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().invokeInsertUser(umcAuthorityAddUserReqBO);
            if (!"0000".equals(umcUpateAuthorityUserRspBO.getRespCode())) {
                throw new UmcBusinessException(umcUpateAuthorityUserRspBO.getRespCode(), umcUpateAuthorityUserRspBO.getRespDesc());
            }
            MemUserPO memUserPO = new MemUserPO();
            memUserPO.setMemId(combReqBO.getMemId());
            memUserPO.setStatus("00");
            MemUserPO memUser = this.memUserMapper.getModelBy(memUserPO);
            if (null == memUser) {
                throw new UmcBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u7528\u6237\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            UmcAuthorityCopyPwdToOthersReqBO umcAuthorityCopyPwdToOthersReqBO = new UmcAuthorityCopyPwdToOthersReqBO();
            umcAuthorityCopyPwdToOthersReqBO.setUserIdReq(memUser.getUsreId());
            umcAuthorityCopyPwdToOthersReqBO.setOtherUserIdReq(userId);
            UmcAuthorityCopyPwdToOthersRspBO umcAuthorityCopyPwdToOthersRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().copyPwdToOthers(umcAuthorityCopyPwdToOthersReqBO);
            if (!"0000".equals(umcAuthorityCopyPwdToOthersRspBO.getRespCode())) {
                throw new UmcBusinessException(umcAuthorityCopyPwdToOthersRspBO.getRespCode(), umcAuthorityCopyPwdToOthersRspBO.getRespDesc());
            }
            UmcMemPartMemBusiReqBO umcMemPartMemBusiReqBO = new UmcMemPartMemBusiReqBO();
            umcMemPartMemBusiReqBO.setMemId(combReqBO.getMemId());
            umcMemPartMemBusiReqBO.setUserId(userId);
            umcMemPartMemBusiReqBO.setOrgId(orgId);
            umcMemPartMemBusiReqBO.setNewRegAccount(newMemRegAccount);
            UmcMemPartMemBusiRspBO umcMemPartMemBusiRspBO = this.umcMemPartMemBusiService.submitMemPartMem(umcMemPartMemBusiReqBO);
            if ("0000".equals(umcMemPartMemBusiRspBO.getRespCode())) continue;
            throw new UmcBusinessException(umcMemPartMemBusiRspBO.getRespCode(), umcMemPartMemBusiRspBO.getRespDesc());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u517c\u804c\u63d0\u4ea4\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private UmcAuthorityAddUserReqBO buildAddUserReqBO(MemberPO member, Long userId, Long targetOrgId) {
        UmcEnterpriseOrgBusiBO busiBO = new UmcEnterpriseOrgBusiBO();
        busiBO.setOrgId(targetOrgId);
        UmcEnterpriseOrgDetailBusiRspBO busiRspBO = this.umcEnterpriseOrgManageBusiService.queryEnterpriseOrgDetail(busiBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        UmcAuthorityAddUserReqBO bo = new UmcAuthorityAddUserReqBO();
        bo.setAuthUserId(userId);
        bo.setLoginNameReq(member.getRegAccount());
        bo.setNameReq(member.getMemName2());
        bo.setCellPhoneReq(member.getRegMobile());
        bo.setEmailReq(member.getRegEmail());
        bo.setType("auth:default:manage");
        bo.setTenantIdReq(busiRspBO.getUmcEnterpriseOrgBO().getTenantId());
        bo.setPasswordReq(member.getPasswd());
        bo.setOrgIdReq(targetOrgId);
        bo.setPassCreate(Integer.valueOf(1));
        return bo;
    }

    private long getRegAccountSequencePager() {
        try {
            return this.regAccountSequencePager.nextId();
        }
        catch (Exception e) {
            if (IS_DEBUG_ENABLE) {
                LOGGER.error("\u83b7\u53d66\u4f4d\u968f\u673a\u6570\u5f02\u5e38\uff1a");
                e.printStackTrace();
            }
            throw new UmcBusinessException("8888", "\u83b7\u53d6\u4f1a\u5458\u6635\u79f0ID\u5f02\u5e38", e);
        }
    }
}

