/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.busi.UmcMemberRatingBusiService;
import com.tydic.umc.busi.UmcTimingTaskMemRatingBusiService;
import com.tydic.umc.busi.bo.UmcMemberRatingBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemberRatingBusiRspBO;
import com.tydic.umc.busi.bo.UmcTimingTaskMemRatingBusiReqBO;
import com.tydic.umc.busi.bo.UmcTimingTaskMemRatingBusiRspBO;
import com.tydic.umc.comb.UmcMemRatingTimingTaskCombService;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.UmcDicDictionaryMapper;
import com.tydic.umc.po.DicDictionaryPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemRatingTimingTaskCombService")
public class UmcMemRatingTimingTaskCombServiceImpl
implements UmcMemRatingTimingTaskCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemRatingTimingTaskCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private MemberMapper memberMapper;
    private UmcTimingTaskMemRatingBusiService umcTimingTaskMemRatingBusiService;
    private UmcMemberRatingBusiService memberRatingBusiService;
    private UmcDicDictionaryMapper dicDictionaryMapper;

    @Autowired
    public UmcMemRatingTimingTaskCombServiceImpl(MemberMapper memberMapper, UmcTimingTaskMemRatingBusiService umcTimingTaskMemRatingBusiService, UmcMemberRatingBusiService memberRatingBusiService, UmcDicDictionaryMapper dicDictionaryMapper) {
        this.memberMapper = memberMapper;
        this.umcTimingTaskMemRatingBusiService = umcTimingTaskMemRatingBusiService;
        this.memberRatingBusiService = memberRatingBusiService;
        this.dicDictionaryMapper = dicDictionaryMapper;
    }

    public void execute(String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u5f00\u59cb\u6267\u884c\u4f1a\u5458\u8bc4\u7ea7\u5b9a\u65f6\u4efb\u52a1=================");
        }
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setPCode("_totalShardCount");
        dicDictionaryModel.setCode("_totalShardCount");
        DicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (dicDictionaryPO == null) {
            LOGGER.info("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u5206\u7247\u503c");
            return;
        }
        String currentDate = DateUtils.dateToStr((Date)new Date());
        String currentTime = currentDate + " 00:00:00";
        List<MemberPO> memberPOS = this.memberMapper.getListByModIdAndDate(dicDictionaryPO.getTitle(), currentShardValue, currentTime);
        if (memberPOS == null || memberPOS.isEmpty()) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u8bc4\u7ea7\u7684\u4f1a\u5458\u4fe1\u606f");
            return;
        }
        for (MemberPO memberPO : memberPOS) {
            if (memberPO.getPlusExpTime() != null && memberPO.getLevelExpTime().compareTo(DateUtils.strToDateLong((String)currentTime)) > 0) continue;
            UmcTimingTaskMemRatingBusiReqBO umcTimingTaskMemRatingBusiReqBO = new UmcTimingTaskMemRatingBusiReqBO();
            umcTimingTaskMemRatingBusiReqBO.setMemId(memberPO.getMemId());
            UmcTimingTaskMemRatingBusiRspBO umcTimingTaskMemRatingBusiRspBO = this.umcTimingTaskMemRatingBusiService.deductionGrow(umcTimingTaskMemRatingBusiReqBO);
            if (!"0000".equals(umcTimingTaskMemRatingBusiRspBO.getRespCode()) && !"1017".equals(umcTimingTaskMemRatingBusiRspBO.getRespCode())) {
                LOGGER.error("\u79ef\u5206\u6263\u51cf\u5931\u8d25");
                continue;
            }
            UmcMemberRatingBusiReqBO umcMemberRatingBusiReqBO = new UmcMemberRatingBusiReqBO();
            umcMemberRatingBusiReqBO.setMemId(memberPO.getMemId());
            UmcMemberRatingBusiRspBO umcMemberRatingBusiRspBO = this.memberRatingBusiService.memberRating(umcMemberRatingBusiReqBO);
            if ("0000".equals(umcMemberRatingBusiRspBO.getRespCode())) continue;
            LOGGER.error("\u4f1a\u5458[{}]\u8bc4\u7ea7\u5931\u8d25\uff0c\u4e0b\u6b21\u8f6e\u8be2", (Object)memberPO.getMemId());
        }
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u4f1a\u5458\u8bc4\u7ea7\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5=================");
        }
    }
}

