/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.DigestUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.busi.UmcEnterpriseOrgManageBusiService;
import com.tydic.umc.busi.UmcMemRegistBusiService;
import com.tydic.umc.busi.UmcVfCodeCheckBusiService;
import com.tydic.umc.busi.bo.FaceInfoBusiBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgBusiBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgDetailBusiRspBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgQryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemRegistBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemRegistBusiRspBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiReqBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiRspBO;
import com.tydic.umc.comb.UmcMemRegistCombService;
import com.tydic.umc.comb.bo.FaceInfoCombBO;
import com.tydic.umc.comb.bo.UmcMemRegistCombReqBO;
import com.tydic.umc.comb.bo.UmcMemRegistCombRspBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityAddUserReqBO;
import com.tydic.umc.external.authority.bo.UmcUpateAuthorityUserRspBO;
import com.tydic.umc.facde.AuthorityServiceHolder;
import com.tydic.umc.util.RspUtils;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="umcMemRegistCombService")
public class UmcMemRegistCombServiceImpl
implements UmcMemRegistCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemRegistCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UmcMemRegistBusiService umcMemRegistBusiService;
    @Autowired
    private UmcVfCodeCheckBusiService umcVfCodeCheckBusiService;
    @Autowired
    private UmcEnterpriseOrgManageBusiService umcEnterpriseOrgManageBusiService;
    @Autowired
    private AuthorityServiceHolder authorityServiceHolder;
    @Value(value="${DEFAULT_ROLE}")
    private String DEFAULT_ROLE;

    public UmcMemRegistCombRspBO dealMemRegist(UmcMemRegistCombReqBO reqBO) {
        UmcMemRegistCombRspBO rspBO = new UmcMemRegistCombRspBO();
        if (this.hasVfCode(reqBO)) {
            UmcVfCodeCheckBusiReqBO checkReqBO = new UmcVfCodeCheckBusiReqBO();
            checkReqBO.setRegMobile(reqBO.getRegMobile());
            checkReqBO.setVFCode(reqBO.getRegVfCode());
            UmcVfCodeCheckBusiRspBO checkRspBO = this.umcVfCodeCheckBusiService.checkVfCode(checkReqBO);
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u9a8c\u8bc1\u7801\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)checkRspBO);
            }
            if (RspUtils.isNotSuccess((UmcRspBaseBO)checkRspBO)) {
                throw new UmcBusinessException("6009", "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff1a" + checkRspBO.getRespDesc());
            }
        }
        UmcMemRegistBusiReqBO busiReqBO = this.buildBusiReq(reqBO);
        Long userId = Sequence.getInstance().nextId();
        if (!"00".equals(reqBO.getMemAffiliation())) {
            UmcAuthorityAddUserReqBO umcAuthorityAddUserReqBO = this.buildAddUserReqBO(reqBO, userId);
            UmcUpateAuthorityUserRspBO rspbo = this.authorityServiceHolder.getUmcExternalAuthorityUserService().invokeInsertUser(umcAuthorityAddUserReqBO);
            if (!"0000".equals(rspbo.getRespCode())) {
                rspBO.setRespCode(rspbo.getRespCode());
                rspBO.setRespDesc(rspbo.getRespDesc());
                return rspBO;
            }
            UmcEnterpriseOrgQryBusiReqBO umcEnterpriseOrgBusiReqBO = new UmcEnterpriseOrgQryBusiReqBO();
            umcEnterpriseOrgBusiReqBO.setOrgId(busiReqBO.getOrgIdWeb());
            UmcEnterpriseOrgDetailBusiRspBO rspBO1 = this.umcEnterpriseOrgManageBusiService.queryParentNotDepartment(umcEnterpriseOrgBusiReqBO);
            if ("0000".equals(rspBO1.getRespCode()) && rspBO1.getUmcEnterpriseOrgBO() != null) {
                busiReqBO.setCompanyId(rspBO1.getUmcEnterpriseOrgBO().getOrgId());
            } else {
                busiReqBO.setCompanyId(reqBO.getOrgIdWeb());
            }
        }
        busiReqBO.setUsreIdWeb(userId);
        if (StringUtils.isEmpty((Object)busiReqBO.getStopStatus())) {
            busiReqBO.setStopStatus("01");
        }
        busiReqBO.setMemClassify("00");
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u6ce8\u518c\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:{}", (Object)busiReqBO);
        }
        UmcMemRegistBusiRspBO busiRspBO = this.umcMemRegistBusiService.dealMemRegist(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        rspBO.setMemId(busiRspBO.getMemId());
        rspBO.setUserId(userId);
        return rspBO;
    }

    private UmcAuthorityAddUserReqBO buildAddUserReqBO(UmcMemRegistCombReqBO reqBO, Long userId) {
        UmcEnterpriseOrgBusiBO busiBO = new UmcEnterpriseOrgBusiBO();
        busiBO.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseOrgDetailBusiRspBO busiRspBO = this.umcEnterpriseOrgManageBusiService.queryEnterpriseOrgDetail(busiBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new UmcBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        UmcAuthorityAddUserReqBO bo = new UmcAuthorityAddUserReqBO();
        bo.setAuthUserId(userId);
        bo.setLoginNameReq(reqBO.getRegAccount());
        bo.setNameReq(reqBO.getMemName2());
        bo.setCellPhoneReq(reqBO.getRegMobile());
        bo.setEmailReq(reqBO.getRegEmail());
        bo.setType(this.DEFAULT_ROLE);
        bo.setTenantIdReq(busiRspBO.getUmcEnterpriseOrgBO().getTenantId());
        bo.setOrgIdReq(reqBO.getOrgIdWeb());
        bo.setPassCreate(reqBO.getPassCreate());
        if (!StringUtils.isEmpty((Object)reqBO.getPasswd())) {
            bo.setPasswordReq(reqBO.getPasswd());
            bo.setPassCreate(Integer.valueOf(2));
        }
        return bo;
    }

    private boolean hasVfCode(UmcMemRegistCombReqBO reqBO) {
        return !StringUtils.isEmpty((Object)reqBO.getRegVfCode());
    }

    private UmcMemRegistBusiReqBO buildBusiReq(UmcMemRegistCombReqBO reqBO) {
        UmcMemRegistBusiReqBO busiReqBO = new UmcMemRegistBusiReqBO();
        busiReqBO.setRegAccount(reqBO.getRegAccount());
        busiReqBO.setRegMobile(reqBO.getRegMobile());
        busiReqBO.setRegEmail(reqBO.getRegEmail());
        busiReqBO.setHeadUrl(reqBO.getHeadUrl());
        busiReqBO.setThirdAuthType(reqBO.getThirdAuthType());
        busiReqBO.setThirdAuthId(reqBO.getThirdAuthId());
        busiReqBO.setAuthExpTime(reqBO.getAuthExpTime());
        busiReqBO.setAccessToken(reqBO.getAccessToken());
        busiReqBO.setRefreshToken(reqBO.getRefreshToken());
        if (!StringUtils.isEmpty((Object)reqBO.getPasswd())) {
            busiReqBO.setPasswd(DigestUtils.Encrypt((String)reqBO.getPasswd(), (String)"MD5"));
        }
        busiReqBO.setMemName1(reqBO.getMemName1());
        busiReqBO.setMemName2(reqBO.getMemName2());
        busiReqBO.setMemNickName(reqBO.getMemNickName());
        busiReqBO.setSex(reqBO.getSex());
        busiReqBO.setCertType(reqBO.getCertType());
        busiReqBO.setCertNo(reqBO.getCertNo());
        busiReqBO.setMemLevel(reqBO.getMemLevel());
        busiReqBO.setMemState(reqBO.getMemState());
        busiReqBO.setMemType(reqBO.getMemType());
        busiReqBO.setBirthday(reqBO.getBirthday());
        busiReqBO.setLevelEffTime(reqBO.getLevelEffTime());
        busiReqBO.setLevelExpTime(reqBO.getLevelExpTime());
        busiReqBO.setIsPlus(reqBO.getIsPlus());
        busiReqBO.setPlusEffTime(reqBO.getPlusEffTime());
        busiReqBO.setPlusExpTime(reqBO.getPlusExpTime());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFaceInfoList())) {
            ArrayList<FaceInfoBusiBO> faceInfoList = new ArrayList<FaceInfoBusiBO>(reqBO.getFaceInfoList().size());
            for (FaceInfoCombBO faceInfoBO : reqBO.getFaceInfoList()) {
                FaceInfoBusiBO busiFaceInfoBO = new FaceInfoBusiBO();
                busiFaceInfoBO.setFaceId(faceInfoBO.getFaceId());
                busiFaceInfoBO.setPhotoType(faceInfoBO.getPhotoType());
                busiFaceInfoBO.setPhotoUrl(faceInfoBO.getPhotoUrl());
                busiFaceInfoBO.setShopCode(faceInfoBO.getShopCode());
                busiFaceInfoBO.setCameraId(faceInfoBO.getCameraId());
                faceInfoList.add(busiFaceInfoBO);
            }
            busiReqBO.setFaceInfoList(faceInfoList);
        }
        busiReqBO.setOrgIdWeb(reqBO.getOrgIdWeb());
        busiReqBO.setWorkNo(reqBO.getWorkNo());
        busiReqBO.setOfficePhone(reqBO.getOfficePhone());
        busiReqBO.setMainMemId(reqBO.getMainMemId());
        busiReqBO.setMemAffiliation(reqBO.getMemAffiliation());
        busiReqBO.setHeight(reqBO.getHeight());
        busiReqBO.setWeight(reqBO.getWeight());
        busiReqBO.setOccupation(reqBO.getOccupation());
        busiReqBO.setIsCreateTbAccount(reqBO.getIsCreateTbAccount());
        if (StringUtils.isEmpty((Object)reqBO.getUserType())) {
            reqBO.setUserType(this.DEFAULT_ROLE);
        }
        busiReqBO.setUserType(reqBO.getUserType());
        busiReqBO.setUnionAuthId(reqBO.getUnionAuthId());
        if (!StringUtils.isEmpty((Object)reqBO.getStopStatus())) {
            busiReqBO.setStopStatus(reqBO.getStopStatus());
        }
        if (reqBO.getRoleIds() != null) {
            busiReqBO.setRoleIds(reqBO.getRoleIds());
        }
        return busiReqBO;
    }
}

