/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcAddEnterpriseAccountBalanceChngLogBusiService;
import com.tydic.umc.busi.UmcWalletBalanceChngBusiService;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiReqBO;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiRspBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiReqBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiRspBO;
import com.tydic.umc.comb.UmcMemWalletImportTimingTaskCombService;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.EnterpriseAccountBalanceMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.MemberWalletImpLogItemMapper;
import com.tydic.umc.dao.MemberWalletImpLogMapper;
import com.tydic.umc.po.EnterpriseAccountBalancePO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.MemberWalletImpLogItemPO;
import com.tydic.umc.po.MemberWalletImpLogPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcMemWalletImportTimingTaskCombService")
public class UmcMemWalletImportTimingTaskCombServiceImpl
implements UmcMemWalletImportTimingTaskCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemWalletImportTimingTaskCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemberWalletImpLogItemMapper memberWalletImpLogItemMapper;
    @Autowired
    private MemberWalletImpLogMapper memberWalletImpLogMapper;
    @Autowired
    private EnterpriseAccountBalanceMapper enterpriseAccountBalanceMapper;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private UmcWalletBalanceChngBusiService umcWalletBalanceChngBusiService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private UmcAddEnterpriseAccountBalanceChngLogBusiService umcAddEnterpriseAccountBalanceChngLogBusiService;

    public void execute(String currentShardValue) {
        List<MemberWalletImpLogPO> memberWalletImpLogPOS;
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5f00\u59cb\u5904\u7406\u7ea2\u5305\u5145\u503c\u5b9a\u65f6\u4efb\u52a1");
        }
        if (CollectionUtils.isEmpty(memberWalletImpLogPOS = this.memberWalletImpLogMapper.getListByStatus(UmcCommConstant.MemberWalletImpLogStatus.NOT_IMP))) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u8bb0\u5f55");
            return;
        }
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u67e5\u8be2\u5230\u8981\u5904\u7406\u7684\u4efb\u52a1\u6570\u6709[{}]\u4e2a", (Object)memberWalletImpLogPOS.size());
        }
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        dicDictionaryBO.setPCode("MEMBER_WALLET_IMP_SHARD_VALUE");
        dicDictionaryBO.setCode("MEMBER_WALLET_IMP_SHARD_VALUE");
        DicDictionaryBO dicDictionary = this.dictionaryBusiService.getDictionaryByBO(dicDictionaryBO);
        if (null == dicDictionary) {
            LOGGER.info("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u5206\u7247\u503c");
            return;
        }
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5b57\u5178\u503c:[{}]", (Object)dicDictionary.getTitle());
            LOGGER.debug("\u5f00\u59cb\u5faa\u73af\u5904\u7406\u7ea2\u5305\u5145\u503c");
        }
        for (MemberWalletImpLogPO memberWalletImpLogPO : memberWalletImpLogPOS) {
            MemberWalletImpLogPO checkWalletImpLogPO = this.memberWalletImpLogMapper.getModelById(memberWalletImpLogPO.getImpId());
            if (null == checkWalletImpLogPO || !UmcCommConstant.MemberWalletImpLogStatus.NOT_IMP.equals(checkWalletImpLogPO.getImpStatus())) continue;
            Long impId = memberWalletImpLogPO.getImpId();
            this.updateImpLogResult(impId, UmcCommConstant.MemberWalletImpLogStatus.IMPING, null, null);
            List<MemberWalletImpLogItemPO> memberWalletImpLogItemPOS = this.memberWalletImpLogItemMapper.getListByImpId(dicDictionary.getTitle(), currentShardValue, impId.toString());
            Integer impStatus = UmcCommConstant.MemberWalletImpLogStatus.IMP_FINISH;
            Integer succCount = 0;
            Long succAmount = 0L;
            if (!CollectionUtils.isEmpty(memberWalletImpLogItemPOS)) {
                for (MemberWalletImpLogItemPO memberWalletImpLogItemPO : memberWalletImpLogItemPOS) {
                    Long memId;
                    List<MemberPO> memberPOS = this.memberMapper.getMemIdByNameMobile(memberWalletImpLogItemPO.getMobile(), memberWalletImpLogItemPO.getAdmOrgId().toString());
                    if (CollectionUtils.isEmpty(memberPOS)) {
                        this.updateItemResult(memberWalletImpLogItemPO.getImpItemId(), null, UmcCommConstant.MemberWalletImpLogItemResult.FAIL, "\u7528\u6237\u672a\u6ce8\u518c");
                        if (!IS_DEBUG_ENABLED) continue;
                        LOGGER.debug("\u59d3\u540d:[{}],\u624b\u673a\u53f7:[{}]\u7684\u7528\u6237\u672a\u6ce8\u518c", (Object)memberWalletImpLogItemPO.getMemName(), (Object)memberWalletImpLogItemPO.getMobile());
                        continue;
                    }
                    if (memberPOS.size() > 1) {
                        this.updateItemResult(memberWalletImpLogItemPO.getImpItemId(), null, UmcCommConstant.MemberWalletImpLogItemResult.FAIL, "\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7528\u6237\u59d3\u540d\u548c\u624b\u673a\u53f7\u7684\u7528\u6237");
                        if (!IS_DEBUG_ENABLED) continue;
                        LOGGER.debug("\u59d3\u540d:[{}],\u624b\u673a\u53f7:[{}]\u7684\u7528\u6237\u5b58\u5728\u591a\u4e2a", (Object)memberWalletImpLogItemPO.getMemName(), (Object)memberWalletImpLogItemPO.getMobile());
                        continue;
                    }
                    Long userId = memId = memberPOS.get(0).getMemId();
                    UmcWalletBalanceChngBusiReqBO umcWalletBalanceChngBusiReqBO = new UmcWalletBalanceChngBusiReqBO();
                    try {
                        umcWalletBalanceChngBusiReqBO.setChargeAmount(MoneyUtils.Long2BigDecimal((Long)memberWalletImpLogItemPO.getImpAmount()));
                    }
                    catch (Exception e) {
                        LOGGER.error("impItemId:[{}]\u7684\u7ea2\u5305\u91d1\u989d\u8f6c\u6362\u5f02\u5e38", (Object)memberWalletImpLogItemPO.getImpItemId());
                        this.updateItemResult(memberWalletImpLogItemPO.getImpItemId(), memId, UmcCommConstant.MemberWalletImpLogItemResult.FAIL, "\u7ea2\u5305\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                        continue;
                    }
                    umcWalletBalanceChngBusiReqBO.setMemId(memId);
                    umcWalletBalanceChngBusiReqBO.setConsumeType(UmcCommConstant.CONSUME_TYPE.CHARGE);
                    umcWalletBalanceChngBusiReqBO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
                    umcWalletBalanceChngBusiReqBO.setTitle("\u7ea2\u5305\u5145\u503c");
                    umcWalletBalanceChngBusiReqBO.setDetail("excel\u5bfc\u5165\u540e\u53f0\u5145\u503c");
                    umcWalletBalanceChngBusiReqBO.setAdmOrgId(memberWalletImpLogItemPO.getAdmOrgId());
                    umcWalletBalanceChngBusiReqBO.setUserId(userId);
                    UmcWalletBalanceChngBusiRspBO busiRspBO = this.umcWalletBalanceChngBusiService.dealWalletBalanceChng(umcWalletBalanceChngBusiReqBO);
                    String remark = "\u5145\u503c\u6210\u529f";
                    Integer impResult = UmcCommConstant.MemberWalletImpLogItemResult.SUCCESS;
                    if (!"0000".equals(busiRspBO.getRespCode())) {
                        remark = busiRspBO.getRespDesc();
                        impResult = UmcCommConstant.MemberWalletImpLogItemResult.FAIL;
                    } else {
                        Integer n = succCount;
                        Integer n2 = succCount = Integer.valueOf(succCount + 1);
                        succAmount = succAmount + memberWalletImpLogItemPO.getImpAmount();
                    }
                    this.updateItemResult(memberWalletImpLogItemPO.getImpItemId(), memId, impResult, remark);
                }
                this.chngLog(memberWalletImpLogPO.getAdmOrgId(), memberWalletImpLogPO.getCreateId(), succAmount);
            } else {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("impId:[{}]\u7684\u7ea2\u5305\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)impId);
                }
                impStatus = UmcCommConstant.MemberWalletImpLogStatus.IMP_FAIL;
            }
            this.updateImpLogResult(impId, impStatus, succCount, succAmount);
            if (!IS_DEBUG_ENABLED) continue;
            LOGGER.debug("impId=[{}]\u7684\u7ea2\u5305\u5145\u503c\u4efb\u52a1\u5b8c\u6210", (Object)impId);
        }
    }

    private void updateItemResult(Long impItemId, Long memId, Integer impResult, String remark) {
        MemberWalletImpLogItemPO memberWalletImpLogItemPO = new MemberWalletImpLogItemPO();
        memberWalletImpLogItemPO.setMemId(memId);
        memberWalletImpLogItemPO.setImpResult(impResult);
        memberWalletImpLogItemPO.setRemark(remark);
        memberWalletImpLogItemPO.setImpItemId(impItemId);
        this.memberWalletImpLogItemMapper.updateByTimingTask(memberWalletImpLogItemPO);
    }

    private void updateImpLogResult(Long impId, Integer impStatus, Integer successCount, Long successAmount) {
        MemberWalletImpLogPO memberWalletImpLogPO = new MemberWalletImpLogPO();
        memberWalletImpLogPO.setImpId(impId);
        memberWalletImpLogPO.setImpStatus(impStatus);
        memberWalletImpLogPO.setSuccessAmount(successAmount);
        memberWalletImpLogPO.setSuccessCount(successCount);
        memberWalletImpLogPO.setUpdateTime(new Date());
        this.memberWalletImpLogMapper.updateByTimingTask(memberWalletImpLogPO);
    }

    private void chngLog(Long orgId, Long memId, Long amount) {
        UmcAddEnterpriseAccountBalanceChngLogBusiReqBO reqBO = new UmcAddEnterpriseAccountBalanceChngLogBusiReqBO();
        EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
        enterpriseAccountBalancePO.setOrgId(orgId);
        List<EnterpriseAccountBalancePO> enterpriseAccountBalancePOS = this.enterpriseAccountBalanceMapper.getList(enterpriseAccountBalancePO);
        if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
            throw new UmcBusinessException("8888", "\u65e0\u5bf9\u5e94\u4f01\u4e1a\u8d26\u5957\u4f59\u989d");
        }
        reqBO.setChngAmount(Long.valueOf(-amount.longValue()));
        reqBO.setTitle("\u7ec4\u7ec7\u673a\u6784\u4f59\u989d\u6263\u51cf");
        reqBO.setDetail("\u540e\u53f0\u7ea2\u5305\u5bfc\u5165\u5145\u503c");
        reqBO.setCreaterId(memId);
        reqBO.setAccountId(enterpriseAccountBalancePOS.get(0).getAccountId());
        reqBO.setOrgId(enterpriseAccountBalancePOS.get(0).getOrgId());
        reqBO.setChngType(Integer.valueOf(2));
        reqBO.setCreateTime(new Date());
        reqBO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
        reqBO.setBusiType(UmcCommConstant.OrgRechargeBusiType.WELFARE);
        reqBO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        reqBO.setBalanceType(UmcCommConstant.EnterpriseBalanceType.ADVANCE_DEPOSIT);
        UmcAddEnterpriseAccountBalanceChngLogBusiRspBO rspBO = this.umcAddEnterpriseAccountBalanceChngLogBusiService.addChngLog(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }
}

