/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcAddBindThirdBusiService;
import com.tydic.umc.busi.UmcMemInfoUpdateBusiService;
import com.tydic.umc.busi.UmcQueryThirdAuthListBusiService;
import com.tydic.umc.busi.UmcUpdateBindThirdBusiService;
import com.tydic.umc.busi.UmcWalletBalanceChngBusiService;
import com.tydic.umc.busi.bo.UmcAddBindThirdBusiReqBO;
import com.tydic.umc.busi.bo.UmcAddBindThirdBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemInfoUpdateBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemInfoUpdateBusiRspBO;
import com.tydic.umc.busi.bo.UmcQueryThirdAuthListBusiReqBO;
import com.tydic.umc.busi.bo.UmcQueryThirdAuthListBusiRspBO;
import com.tydic.umc.busi.bo.UmcUpdateBindThirdBusiReqBO;
import com.tydic.umc.busi.bo.UmcUpdateBindThirdBusiRspBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiReqBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiRspBO;
import com.tydic.umc.comb.UmcMobileBindCombService;
import com.tydic.umc.comb.bo.UmcMobileBindCombReqBO;
import com.tydic.umc.comb.bo.UmcMobileBindCombRspBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.common.UmcThirdBindBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.EnterpriseGrantDAO;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.MemberWalletMapper;
import com.tydic.umc.po.EnterpriseGrantPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.MemberWalletPO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="umcMobileBindCombService")
public class UmcMobileBindCombServiceImpl
implements UmcMobileBindCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMobileBindCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UmcMemInfoUpdateBusiService umcMemInfoUpdateBusiService;
    @Autowired
    private MemberWalletMapper memberWalletMapper;
    @Autowired
    private UmcWalletBalanceChngBusiService umcWalletBalanceChngBusiService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private UmcQueryThirdAuthListBusiService umcQueryThirdAuthListBusiService;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private EnterpriseGrantDAO enterpriseGrantDAO;
    @Autowired
    private UmcUpdateBindThirdBusiService umcUpdateBindThirdBusiService;
    @Autowired
    private UmcAddBindThirdBusiService umcAddBindThirdBusiService;
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;

    public UmcMobileBindCombRspBO mobileBind(UmcMobileBindCombReqBO reqBO) {
        UmcMobileBindCombRspBO rspBO = new UmcMobileBindCombRspBO();
        List<MemberPO> loginMemberPOS = this.getMemInfo(null, reqBO.getMemIdExt(), reqBO.getAdmOrgId());
        if (CollectionUtils.isEmpty(loginMemberPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            return rspBO;
        }
        UmcEnterpriseOrgBO umcEnterpriseOrgBO = this.checkOrg(reqBO.getAdmOrgId());
        Boolean shopInner = this.checkShopInner(umcEnterpriseOrgBO.getOrgCode());
        List<MemberPO> mobileMemberPOS = this.getMemInfo(reqBO.getRegMobile(), null, reqBO.getAdmOrgId());
        if (UmcEnumConstant.ThirdAuthType.DD_THIRD.getCode().equals(reqBO.getBindType())) {
            List<UmcThirdBindBO> umcThirdBindBOS;
            if (!CollectionUtils.isEmpty(mobileMemberPOS)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5f53\u524d\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
                return rspBO;
            }
            if (shopInner.booleanValue() && CollectionUtils.isEmpty(umcThirdBindBOS = this.getThirdInfo(reqBO.getMemIdExt(), reqBO.getBindType()))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u975e\u5185\u8d2d\u4f1a\u5458\u4e0d\u80fd\u7ed1\u5b9a\u624b\u673a");
                return rspBO;
            }
            this.bind(reqBO.getRegMobile(), reqBO.getMemIdExt());
            this.dealEnterpriseGrant(reqBO, rspBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7ed1\u5b9a\u6210\u529f");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(mobileMemberPOS)) {
            if (shopInner.booleanValue()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u975e\u5185\u8d2d\u4f1a\u5458\u4e0d\u80fd\u7ed1\u5b9a\u624b\u673a");
                return rspBO;
            }
            this.bind(reqBO.getRegMobile(), reqBO.getMemIdExt());
            this.dealEnterpriseGrant(reqBO, rspBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7ed1\u5b9a\u6210\u529f");
            return rspBO;
        }
        Long existMemId = mobileMemberPOS.get(0).getMemId();
        if (reqBO.getMemIdExt().equals(existMemId)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7528\u6237\u5df2\u7ed1\u5b9a");
            return rspBO;
        }
        MemberWalletPO memberWalletPO = this.getBalance(existMemId);
        if (null != memberWalletPO) {
            BigDecimal balance = null;
            try {
                balance = MoneyUtils.Long2BigDecimal((Long)memberWalletPO.getBalance());
            }
            catch (Exception e) {
                LOGGER.error("\u94b1\u5305\u4f59\u989d\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u94b1\u5305\u4f59\u989d\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38");
            }
            this.dealCharge(reqBO.getMemIdExt(), reqBO.getAdmOrgId(), balance, "\u5408\u5e76\u7528\u6237\u94b1\u5305", "\u5408\u5e76\u7528\u6237\u94b1\u5305", UmcCommConstant.CONSUME_TYPE.MERGE_WALLET);
        }
        List<UmcThirdBindBO> umcThirdBindBOS = this.getThirdInfo(existMemId, reqBO.getBindType());
        this.deleteMem(existMemId);
        this.updateMem(reqBO.getMemIdExt(), mobileMemberPOS.get(0).getWorkNo(), mobileMemberPOS.get(0).getCertNo(), mobileMemberPOS.get(0).getCertType());
        if (!CollectionUtils.isEmpty(umcThirdBindBOS)) {
            this.updateThird(existMemId, reqBO.getBindType());
            for (UmcThirdBindBO umcThirdBindBO : umcThirdBindBOS) {
                umcThirdBindBO.setMemId(reqBO.getMemIdExt());
                umcThirdBindBO.setCreateTime(new Date());
                this.addThird(umcThirdBindBO);
            }
        }
        this.bind(reqBO.getRegMobile(), reqBO.getMemIdExt());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<MemberPO> getMemInfo(String regMobile, Long memId, Long orgId) {
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(memId);
        memberPO.setOrgId(orgId);
        memberPO.setRegMobile(regMobile);
        return this.memberMapper.getMemInfoByCondition(memberPO);
    }

    private void bind(String regMobile, Long memId) {
        UmcMemInfoUpdateBusiReqBO umcMemInfoUpdateBusiReqBO = new UmcMemInfoUpdateBusiReqBO();
        umcMemInfoUpdateBusiReqBO.setMemId(memId);
        umcMemInfoUpdateBusiReqBO.setRegMobile(regMobile);
        umcMemInfoUpdateBusiReqBO.setOperType(UmcEnumConstant.MemLogType.BIND_MOBILE.getCode());
        umcMemInfoUpdateBusiReqBO.setOperDesc(UmcEnumConstant.MemLogType.BIND_MOBILE.getName());
        umcMemInfoUpdateBusiReqBO.setOperResult("\u7ed1\u5b9a\u6210\u529f");
        umcMemInfoUpdateBusiReqBO.setUserId(memId);
        UmcMemInfoUpdateBusiRspBO umcMemInfoUpdateBusiRspBO = this.umcMemInfoUpdateBusiService.updateMemInfo(umcMemInfoUpdateBusiReqBO);
        if (!"0000".equals(umcMemInfoUpdateBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcMemInfoUpdateBusiRspBO.getRespCode(), umcMemInfoUpdateBusiRspBO.getRespDesc());
        }
    }

    private MemberWalletPO getBalance(Long memId) {
        MemberWalletPO po = new MemberWalletPO();
        po.setMemId(memId);
        po.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
        return this.memberWalletMapper.getModelBy(po);
    }

    private void deleteMem(Long memId) {
        UmcMemInfoUpdateBusiReqBO umcMemInfoUpdateBusiReqBO = new UmcMemInfoUpdateBusiReqBO();
        umcMemInfoUpdateBusiReqBO.setMemId(memId);
        umcMemInfoUpdateBusiReqBO.setOperType(UmcEnumConstant.MemLogType.BIND_MOBILE.getCode());
        umcMemInfoUpdateBusiReqBO.setOperDesc("\u5408\u5e76\u7528\u6237\uff0c\u5931\u6548\u5b58\u5728\u7528\u6237\uff0c\u4fdd\u7559\u5f53\u524d\u767b\u5f55\u7528\u6237");
        umcMemInfoUpdateBusiReqBO.setOperResult("\u5408\u5e76\u6210\u529f");
        umcMemInfoUpdateBusiReqBO.setUserId(memId);
        umcMemInfoUpdateBusiReqBO.setState(UmcCommConstant.MemState.INVALID);
        UmcMemInfoUpdateBusiRspBO umcMemInfoUpdateBusiRspBO = this.umcMemInfoUpdateBusiService.updateMemInfo(umcMemInfoUpdateBusiReqBO);
        if (!"0000".equals(umcMemInfoUpdateBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcMemInfoUpdateBusiRspBO.getRespCode(), umcMemInfoUpdateBusiRspBO.getRespDesc());
        }
    }

    private void dealCharge(Long memId, Long admOrgId, BigDecimal chargeAmount, String title, String detail, Integer consumeType) {
        UmcWalletBalanceChngBusiReqBO umcWalletBalanceChngBusiReqBO = new UmcWalletBalanceChngBusiReqBO();
        umcWalletBalanceChngBusiReqBO.setMemId(memId);
        umcWalletBalanceChngBusiReqBO.setChargeAmount(chargeAmount);
        umcWalletBalanceChngBusiReqBO.setConsumeType(consumeType);
        umcWalletBalanceChngBusiReqBO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
        umcWalletBalanceChngBusiReqBO.setTitle(title);
        umcWalletBalanceChngBusiReqBO.setDetail(detail);
        umcWalletBalanceChngBusiReqBO.setAdmOrgId(admOrgId);
        UmcWalletBalanceChngBusiRspBO busiRspBO = this.umcWalletBalanceChngBusiService.dealWalletBalanceChng(umcWalletBalanceChngBusiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new UmcBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
    }

    private String getDic(String pCode) {
        List dicDictionaryBOS = this.dictionaryBusiService.queryBypCodeBackPo("UMC", pCode);
        if (!CollectionUtils.isEmpty((Collection)dicDictionaryBOS)) {
            return ((DicDictionaryBO)dicDictionaryBOS.get(0)).getCode();
        }
        return null;
    }

    private List<UmcThirdBindBO> getThirdInfo(Long memId, Integer bindType) {
        UmcQueryThirdAuthListBusiReqBO umcQueryThirdAuthListBusiReqBO = new UmcQueryThirdAuthListBusiReqBO();
        umcQueryThirdAuthListBusiReqBO.setAuthType(bindType);
        umcQueryThirdAuthListBusiReqBO.setMemId(memId);
        umcQueryThirdAuthListBusiReqBO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        UmcQueryThirdAuthListBusiRspBO UmcQueryThirdAuthListBusiRspBO2 = this.umcQueryThirdAuthListBusiService.queryThirdAuthList(umcQueryThirdAuthListBusiReqBO);
        if ("0000".equals(UmcQueryThirdAuthListBusiRspBO2.getRespCode())) {
            return UmcQueryThirdAuthListBusiRspBO2.getRows();
        }
        return new ArrayList<UmcThirdBindBO>();
    }

    private void updateMem(Long memId, String workNo, String certNo, Integer certType) {
        UmcMemInfoUpdateBusiReqBO umcMemInfoUpdateBusiReqBO = new UmcMemInfoUpdateBusiReqBO();
        umcMemInfoUpdateBusiReqBO.setMemId(memId);
        umcMemInfoUpdateBusiReqBO.setOperType(UmcEnumConstant.MemLogType.BIND_MOBILE.getCode());
        umcMemInfoUpdateBusiReqBO.setOperDesc("\u5408\u5e76\u7528\u6237\uff0c\u5c06\u5931\u6548\u7528\u6237\u4fe1\u606f\u66f4\u65b0\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237");
        umcMemInfoUpdateBusiReqBO.setOperResult("\u5408\u5e76\u6210\u529f");
        umcMemInfoUpdateBusiReqBO.setUserId(memId);
        umcMemInfoUpdateBusiReqBO.setCertNo(certNo);
        umcMemInfoUpdateBusiReqBO.setCertType(certType);
        umcMemInfoUpdateBusiReqBO.setWorkNo(workNo);
        UmcMemInfoUpdateBusiRspBO umcMemInfoUpdateBusiRspBO = this.umcMemInfoUpdateBusiService.updateMemInfo(umcMemInfoUpdateBusiReqBO);
        if (!"0000".equals(umcMemInfoUpdateBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcMemInfoUpdateBusiRspBO.getRespCode(), umcMemInfoUpdateBusiRspBO.getRespDesc());
        }
    }

    private void updateThird(Long memId, Integer bindType) {
        UmcUpdateBindThirdBusiReqBO reqBO = new UmcUpdateBindThirdBusiReqBO();
        reqBO.setMemId(memId);
        reqBO.setAuthType(bindType);
        reqBO.setState(UmcEnumConstant.State.INVALID.getCode());
        UmcUpdateBindThirdBusiRspBO rspBO = this.umcUpdateBindThirdBusiService.updateBindThird(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void addThird(UmcThirdBindBO umcThirdBindBO) {
        UmcAddBindThirdBusiReqBO reqBO = new UmcAddBindThirdBusiReqBO();
        umcThirdBindBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        BeanUtils.copyProperties((Object)umcThirdBindBO, (Object)reqBO);
        UmcAddBindThirdBusiRspBO rspBO = this.umcAddBindThirdBusiService.addBindThird(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private UmcEnterpriseOrgBO checkOrg(Long orgId) {
        UmcEnterpriseOrgBO umcEnterpriseOrgBO = this.enterpriseOrgMapper.getModelById(orgId);
        if (null == umcEnterpriseOrgBO) {
            throw new UmcBusinessException("8888", "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        return umcEnterpriseOrgBO;
    }

    private Boolean checkShopInner(String orgCode) {
        String code = this.getDic(orgCode);
        if (!StringUtils.isEmpty((Object)code) && "1".equals(code)) {
            return true;
        }
        return false;
    }

    private void dealEnterpriseGrant(UmcMobileBindCombReqBO reqBO, UmcMobileBindCombRspBO rspBO) {
        EnterpriseGrantPO enterpriseGrantPO = this.enterpriseGrantDAO.selectByOrgId(reqBO.getAdmOrgId());
        if (null != enterpriseGrantPO) {
            BigDecimal balance = null;
            try {
                balance = MoneyUtils.Long2BigDecimal((Long)enterpriseGrantPO.getBalance());
            }
            catch (Exception e) {
                LOGGER.error("\u673a\u6784\u91d1\u989d\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u673a\u6784\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            String msg = "\u7ed1\u5b9a\u624b\u673a\u9886\u53d6\u7ea2\u5305" + balance + "\u5143";
            this.dealCharge(reqBO.getMemIdExt(), reqBO.getAdmOrgId(), balance, msg, msg, UmcCommConstant.CONSUME_TYPE.BING_MOBILE_GRANT);
            rspBO.setFee(balance);
        }
    }
}

