/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.busi.UmcSignGiveIntegralBusiService;
import com.tydic.umc.busi.UmcSignGiveIntegralControlBusiService;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralBusiReqBO;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralBusiRspBO;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralControlBusiReqBO;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralControlBusiRspBO;
import com.tydic.umc.comb.UmcSignGiveIntegralCombService;
import com.tydic.umc.comb.bo.UmcSignGiveIntegralCombReqBO;
import com.tydic.umc.comb.bo.UmcSignGiveIntegralCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.OperRulePO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcSignGiveIntegralCombService")
public class UmcSignGiveIntegralCombServiceImpl
implements UmcSignGiveIntegralCombService {
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;
    private OperRuleMapper operRuleMapper;
    private UmcSignGiveIntegralControlBusiService umcSignGiveIntegralControlBusiService;
    private UmcSignGiveIntegralBusiService umcSignGiveIntegralBusiService;

    @Autowired
    public UmcSignGiveIntegralCombServiceImpl(UmcRuleCalculateAtomService umcRuleCalculateAtomService, OperRuleMapper operRuleMapper, UmcSignGiveIntegralControlBusiService umcSignGiveIntegralControlBusiService, UmcSignGiveIntegralBusiService umcSignGiveIntegralBusiService) {
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
        this.operRuleMapper = operRuleMapper;
        this.umcSignGiveIntegralControlBusiService = umcSignGiveIntegralControlBusiService;
        this.umcSignGiveIntegralBusiService = umcSignGiveIntegralBusiService;
    }

    public UmcSignGiveIntegralCombRspBO addSignAndIntegral(UmcSignGiveIntegralCombReqBO umcSignGiveIntegralCombReqBO) {
        UmcSignGiveIntegralCombRspBO rspBO = new UmcSignGiveIntegralCombRspBO();
        Long recvIntegral = umcSignGiveIntegralCombReqBO.getRecvIntegral() == null ? 0L : umcSignGiveIntegralCombReqBO.getRecvIntegral();
        UmcRuleCalculateAtomRspBO obtainIntegralRspBO = this.obtainIntegral();
        if (!"0000".equals(obtainIntegralRspBO.getRespCode())) {
            rspBO.setRespCode(obtainIntegralRspBO.getRespCode());
            rspBO.setRespDesc(obtainIntegralRspBO.getRespDesc());
            return rspBO;
        }
        Long integral = Long.valueOf(obtainIntegralRspBO.getTargetValue());
        Long newIntegral = recvIntegral + integral;
        UmcSignGiveIntegralControlBusiRspBO signGiveIntegralControlBusiRspBO = this.signGiveIntegralControl(integral);
        if (!"0000".equals(signGiveIntegralControlBusiRspBO.getRespCode())) {
            rspBO.setRespCode(signGiveIntegralControlBusiRspBO.getRespCode());
            rspBO.setRespDesc(signGiveIntegralControlBusiRspBO.getRespDesc());
            return rspBO;
        }
        UmcSignGiveIntegralBusiRspBO signGiveIntegralBusiRspBO = this.addSignAndIntegral(umcSignGiveIntegralCombReqBO, newIntegral);
        if (!"0000".equals(signGiveIntegralBusiRspBO.getRespCode())) {
            rspBO.setRespCode(signGiveIntegralBusiRspBO.getRespCode());
            rspBO.setRespDesc(signGiveIntegralBusiRspBO.getRespDesc());
            this.signGiveIntegralControl(-integral.longValue());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7b7e\u5230\u9001\u79ef\u5206\u8d60\u9001\u6210\u529f");
        return rspBO;
    }

    private UmcRuleCalculateAtomRspBO obtainIntegral() {
        UmcRuleCalculateAtomRspBO rspBO = new UmcRuleCalculateAtomRspBO();
        OperRulePO operRulePO = this.qryOperRule();
        if (operRulePO == null) {
            rspBO.setRespCode("2016");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddIntegralOperCode.SIGN_IN.getCode() + "]\u4e14\u7c7b\u578b\u4e3a[" + UmcCommConstant.RuleType.OTHER + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            return rspBO;
        }
        UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.calcObtainIntegral(operRulePO);
        if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcRuleCalculateAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcRuleCalculateAtomRspBO.getRespDesc());
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)umcRuleCalculateAtomRspBO.getTargetValue())) {
            rspBO.setRespCode("2014");
            rspBO.setRespDesc("\u7b7e\u5230\u9001\u79ef\u5206\u6267\u884c\u5931\u8d25,\u672a\u6210\u529f\u8ba1\u7b97\u5230\u5f53\u524d\u7b7e\u5230\u6240\u8d60\u9001\u7684\u79ef\u5206");
            return rspBO;
        }
        return umcRuleCalculateAtomRspBO;
    }

    private OperRulePO qryOperRule() {
        OperRulePO operRuleModel = new OperRulePO();
        operRuleModel.setRuleType(UmcCommConstant.RuleType.SIGN_GIVE_INTEGRAL);
        operRuleModel.setOperCode(UmcEnumConstant.AddIntegralOperCode.SIGN_IN.getCode());
        return this.operRuleMapper.getModelByCondition(operRuleModel);
    }

    private UmcRuleCalculateAtomRspBO calcObtainIntegral(OperRulePO operRulePO) {
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(operRulePO.getRuleId());
        umcRuleCalculateAtomReqBO.setRuleType(operRulePO.getRuleType());
        return this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
    }

    private UmcSignGiveIntegralControlBusiRspBO signGiveIntegralControl(Long integral) {
        UmcSignGiveIntegralControlBusiReqBO reqBO = new UmcSignGiveIntegralControlBusiReqBO();
        reqBO.setIntegral(integral);
        return this.umcSignGiveIntegralControlBusiService.signGiveIntegralControl(reqBO);
    }

    private UmcSignGiveIntegralBusiRspBO addSignAndIntegral(UmcSignGiveIntegralCombReqBO reqBO, Long newIntegral) {
        UmcSignGiveIntegralBusiReqBO umcSignGiveIntegralBusiReqBO = new UmcSignGiveIntegralBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcSignGiveIntegralBusiReqBO);
        umcSignGiveIntegralBusiReqBO.setRecvIntegral(newIntegral);
        return this.umcSignGiveIntegralBusiService.addSignAndIntegral(umcSignGiveIntegralBusiReqBO);
    }
}

