/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.comb.UmcVfCodeCleanTimingTaskCombService;
import com.tydic.umc.dao.VfCodeMapper;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcVfCodeCleanTimingTaskCombService")
public class UmcVfCodeCleanTimingTaskCombServiceImpl
implements UmcVfCodeCleanTimingTaskCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcVfCodeCleanTimingTaskCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private VfCodeMapper vfCodeMapper;

    @Autowired
    public UmcVfCodeCleanTimingTaskCombServiceImpl(VfCodeMapper vfCodeMapper) {
        this.vfCodeMapper = vfCodeMapper;
    }

    public void execute(String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u9a8c\u8bc1\u7801\u8868\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u5f00\u59cb=================");
        }
        Date dayOfMonthBegin = this.getBigenAndEndDay().get("fristDay");
        Date dayOfMonthEnd = this.getBigenAndEndDay().get("lastDay");
        int isDelete = this.vfCodeMapper.deleteByCreateTime(dayOfMonthBegin, dayOfMonthEnd);
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("===============\u9a8c\u8bc1\u7801\u8868\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u7ed3\u675f=================");
        }
    }

    private Map<String, Date> getBigenAndEndDay() {
        HashMap<String, Date> result = new HashMap<String, Date>();
        Calendar cale = Calendar.getInstance();
        cale.add(2, -1);
        cale.set(5, 1);
        String fristDay = DateUtils.dateToStr((Date)cale.getTime()) + " 00:00:00";
        Date fristDay1 = DateUtils.strToDateLong((String)fristDay);
        result.put("fristDay", fristDay1);
        cale = Calendar.getInstance();
        cale.set(5, 1);
        cale.add(5, -1);
        String lastDay = DateUtils.dateToStr((Date)cale.getTime()) + " 23:59:59";
        Date lastDay1 = DateUtils.strToDateLong((String)lastDay);
        result.put("lastDay", lastDay1);
        return result;
    }
}

