/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.comb.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.umc.busi.UmcAddEnterpriseAccountBalanceChngLogBusiService;
import com.tydic.umc.busi.UmcWalletBalanceChngBusiService;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiReqBO;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiRspBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiReqBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiRspBO;
import com.tydic.umc.comb.UmcWalletBatchChargeCombService;
import com.tydic.umc.comb.bo.UmcWalletBatchChargeCombReqBO;
import com.tydic.umc.comb.bo.UmcWalletBatchChargeCombRspBO;
import com.tydic.umc.common.UmcWalletChargeBO;
import com.tydic.umc.common.WalletChargeResultBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.EnterpriseAccountBalanceMapper;
import com.tydic.umc.external.commodity.UmcExternalRechargePwdVerifyService;
import com.tydic.umc.external.commodity.bo.UmcExternalRechargePwdVerifyReqBO;
import com.tydic.umc.external.commodity.bo.UmcExternalRechargePwdVerifyRspBO;
import com.tydic.umc.po.EnterpriseAccountBalancePO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcWalletBatchChargeCombService")
public class UmcWalletBatchChargeCombServiceImpl
implements UmcWalletBatchChargeCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcWalletBatchChargeCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UmcWalletBalanceChngBusiService umcWalletBalanceChngBusiService;
    @Autowired
    private UmcExternalRechargePwdVerifyService umcExternalRechargePwdVerifyService;
    @Autowired
    private UmcAddEnterpriseAccountBalanceChngLogBusiService umcAddEnterpriseAccountBalanceChngLogBusiService;
    @Autowired
    private EnterpriseAccountBalanceMapper enterpriseAccountBalanceMapper;

    public UmcWalletBatchChargeCombRspBO walletBatchCharge(UmcWalletBatchChargeCombReqBO reqBO) {
        BigDecimal sumAmount;
        ArrayList<WalletChargeResultBO> resultBOList;
        UmcWalletBatchChargeCombRspBO rspBO = new UmcWalletBatchChargeCombRspBO();
        if (!StringUtils.isBlank((CharSequence)reqBO.getAdmPassword())) {
            this.checkPasswd(reqBO.getAdmPassword(), reqBO.getAdmOrgId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWalletChargeList())) {
            resultBOList = new ArrayList<WalletChargeResultBO>();
            sumAmount = new BigDecimal(0);
            for (UmcWalletChargeBO walletChargeBO : reqBO.getWalletChargeList()) {
                UmcWalletBalanceChngBusiReqBO busiReqBO = new UmcWalletBalanceChngBusiReqBO();
                WalletChargeResultBO resultBO = new WalletChargeResultBO();
                busiReqBO.setMemId(walletChargeBO.getMemId());
                busiReqBO.setWalletId(walletChargeBO.getWalletId());
                busiReqBO.setConsumeType(UmcCommConstant.CONSUME_TYPE.CHARGE);
                if (walletChargeBO.getWalletType() == null) {
                    busiReqBO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
                } else {
                    busiReqBO.setWalletType(walletChargeBO.getWalletType());
                }
                busiReqBO.setChargeAmount(walletChargeBO.getChargeAmount());
                busiReqBO.setTitle(reqBO.getTitle());
                busiReqBO.setDetail(reqBO.getDetail());
                busiReqBO.setRemark(reqBO.getRemark());
                busiReqBO.setAdmOrgId(reqBO.getAdmOrgId());
                UmcWalletBalanceChngBusiRspBO busiRspBO = this.umcWalletBalanceChngBusiService.dealWalletBalanceChng(busiReqBO);
                resultBO.setMemName(busiRspBO.getMemName());
                resultBO.setChargeAmount(busiRspBO.getChargeAmount());
                resultBO.setChargeResult(busiRspBO.getChargeResult());
                resultBO.setMemId(walletChargeBO.getMemId());
                if (!"0000".equals(busiRspBO.getRespCode())) {
                    resultBO.setChargeResult(busiRspBO.getRespDesc());
                } else {
                    sumAmount = sumAmount.add(walletChargeBO.getChargeAmount());
                }
                resultBOList.add(resultBO);
            }
        } else {
            throw new UmcBusinessException("8888", "\u5145\u503c\u5165\u53c2\u91cc\u94b1\u5305\u4e3a\u7a7a\uff01");
        }
        this.chngLog(reqBO, sumAmount);
        rspBO.setWalletChargeResultList(resultBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkPasswd(String pwd, Long orgId) {
        UmcExternalRechargePwdVerifyReqBO umcExternalRechargePwdVerifyReqBO = new UmcExternalRechargePwdVerifyReqBO();
        umcExternalRechargePwdVerifyReqBO.setRechargePassword(pwd);
        umcExternalRechargePwdVerifyReqBO.setSupplierId(orgId);
        UmcExternalRechargePwdVerifyRspBO UmcExternalRechargePwdVerifyRspBO2 = this.umcExternalRechargePwdVerifyService.rechargePwdVerify(umcExternalRechargePwdVerifyReqBO);
        if (!"0000".equals(UmcExternalRechargePwdVerifyRspBO2.getRespCode())) {
            throw new UmcBusinessException("8888", "\u5546\u54c1\u4e2d\u5fc3\u9a8c\u8bc1\u5bc6\u7801\u8fd4\u56de\u5931\u8d25");
        }
        if (!UmcExternalRechargePwdVerifyRspBO2.isVerify()) {
            throw new UmcBusinessException("8888", "\u5bc6\u7801\u9519\u8bef");
        }
    }

    private void chngLog(UmcWalletBatchChargeCombReqBO umcWalletBatchChargeCombReqBO, BigDecimal amount) {
        UmcAddEnterpriseAccountBalanceChngLogBusiReqBO reqBO = new UmcAddEnterpriseAccountBalanceChngLogBusiReqBO();
        EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
        enterpriseAccountBalancePO.setOrgId(umcWalletBatchChargeCombReqBO.getAdmOrgId());
        List<EnterpriseAccountBalancePO> enterpriseAccountBalancePOS = this.enterpriseAccountBalanceMapper.getList(enterpriseAccountBalancePO);
        if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
            throw new UmcBusinessException("8888", "\u65e0\u5bf9\u5e94\u4f01\u4e1a\u8d26\u5957\u4f59\u989d");
        }
        try {
            reqBO.setChngAmount(Long.valueOf(-MoneyUtils.BigDecimal2Long((BigDecimal)amount).longValue()));
        }
        catch (Exception e) {
            LOGGER.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        reqBO.setTitle("\u7ec4\u7ec7\u673a\u6784\u4f59\u989d\u6263\u51cf");
        reqBO.setDetail("\u7ea2\u5305\u6279\u91cf\u5145\u503c");
        reqBO.setCreaterId(umcWalletBatchChargeCombReqBO.getMemIdIn());
        reqBO.setAccountId(enterpriseAccountBalancePOS.get(0).getAccountId());
        reqBO.setOrgId(enterpriseAccountBalancePOS.get(0).getOrgId());
        reqBO.setChngType(Integer.valueOf(2));
        reqBO.setCreateTime(new Date());
        reqBO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
        reqBO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        reqBO.setBusiType(UmcCommConstant.OrgRechargeBusiType.WELFARE);
        UmcAddEnterpriseAccountBalanceChngLogBusiRspBO rspBO = this.umcAddEnterpriseAccountBalanceChngLogBusiService.addChngLog(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }
}

