/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.busi.UmcEnterpriseOrgManageBusiService;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgBusiBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.SupplierInfoChngDAO;
import com.tydic.umc.dao.SupplierInfoDAO;
import com.tydic.umc.dao.UmcDicDictionaryMapper;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.external.authority.bo.UmcAuthoritySaveUserAuthReqBO;
import com.tydic.umc.external.authority.bo.UmcAuthoritySaveUserAuthRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.facde.AuthorityServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupAdmittanceAduitBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupAdmittanceAduitBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupAdmittanceAduitBusiRspBO;
import com.tydic.umc.po.DicDictionaryPO;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.po.SupplierInfoPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="umcSupAdmittanceAduitBusiService")
public class UmcSupAdmittanceAduitBusiServiceImpl
implements UmcSupAdmittanceAduitBusiService {
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Autowired
    private SupplierInfoDAO supplierInfoDAO;
    @Autowired
    private SupplierInfoChngDAO supplierInfoChngDAO;
    @Autowired
    private MemUserMapper memUserMapper;
    @Autowired
    private UmcEnterpriseOrgManageBusiService umcEnterpriseOrgManageBusiService;
    @Autowired
    private AuthorityServiceHolder authorityServiceHolder;
    @Autowired
    private UmcDicDictionaryMapper dicDictionaryMapper;

    public UmcSupAdmittanceAduitBusiRspBO dealUmcSupAdmittanceAudit(UmcSupAdmittanceAduitBusiReqBO reqBO) {
        UmcSupAdmittanceAduitBusiRspBO rspBO = new UmcSupAdmittanceAduitBusiRspBO();
        SupplierInfoPO supplierInfoPO = new SupplierInfoPO();
        supplierInfoPO.setSupplierIds(reqBO.getSupplierIdList());
        supplierInfoPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        supplierInfoPO.setObjType(UmcCommConstant.AuditObjType.SUP_ADMITTANCE_ADUIT);
        List<SupplierInfoPO> supplierInfoPOS = this.supplierInfoChngDAO.getListTask(supplierInfoPO);
        this.checkSupplierInfoPOS(supplierInfoPOS, reqBO.getSupplierIdList().size());
        this.updateSupplierInfo(supplierInfoPOS, reqBO);
        Integer auditResult = reqBO.getApprovalType() == 1 ? 0 : 1;
        supplierInfoPOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            ArrayList<Long> supplierIdList = new ArrayList<Long>();
            supplierIdList.add(po.getSupplierId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(supplierIdList);
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_ADMITTANCE_ADUIT));
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
            if (auditResult.equals(0)) {
                UmcEnterpriseOrgBusiBO umcEnterpriseOrgBusiBO = new UmcEnterpriseOrgBusiBO();
                umcEnterpriseOrgBusiBO.setOrgName(po.getSupplierName());
                umcEnterpriseOrgBusiBO.setOrgCode(po.getSupplierEnName());
                umcEnterpriseOrgBusiBO.setOrgId(po.getOrgCode());
                umcEnterpriseOrgBusiBO.setLinkMan(po.getLinkMan());
                umcEnterpriseOrgBusiBO.setPhone(po.getPhoneNumber());
                umcEnterpriseOrgBusiBO.setMailbox(po.getEmail());
                umcEnterpriseOrgBusiBO.setAlias(po.getSupplierAlias());
                umcEnterpriseOrgBusiBO.setAddress(po.getAddrDesc());
                UmcEnterpriseOrgBusiRspBO umcEnterpriseOrgBusiRspBO = this.umcEnterpriseOrgManageBusiService.updateUmcEnterpriseOrg(umcEnterpriseOrgBusiBO);
                if (!"0000".equals(umcEnterpriseOrgBusiRspBO.getRespCode())) {
                    throw new UmcBusinessException(umcEnterpriseOrgBusiRspBO.getRespCode(), umcEnterpriseOrgBusiRspBO.getRespDesc());
                }
                DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
                dicDictionaryPO.setPCode("SUP_BUSI_ROLE");
                DicDictionaryPO dicResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
                if (!StringUtils.isEmpty((Object)dicResult) && !StringUtils.isEmpty((Object)dicResult.getCode())) {
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    for (SupplierInfoPO po1 : supplierInfoPOS) {
                        SupplierInfoPO supplierInfoPO1 = new SupplierInfoPO();
                        supplierInfoPO1.setOrgCode(po1.getOrgCode());
                        orgIds.add(supplierInfoPO1.getOrgCode());
                    }
                    MemUserPO memUserPO = new MemUserPO();
                    memUserPO.setOrgIds(orgIds);
                    List<MemUserPO> memUserPOList = this.memUserMapper.getListByOrgIds(memUserPO);
                    if (memUserPOList == null) {
                        throw new UmcBusinessException("8888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u6240\u5728\u673a\u6784\u7528\u6237\u7ed3\u679c\u4e3a\u7a7a");
                    }
                    UmcAuthoritySaveUserAuthReqBO umcAuthoritySaveUserAuthReqBO = new UmcAuthoritySaveUserAuthReqBO();
                    JSONObject json = new JSONObject();
                    memUserPOList.stream().forEach(po2 -> json.put(po2.getUsreId().toString(), (Object)UmcCommConstant.RoleOperType.ADD));
                    umcAuthoritySaveUserAuthReqBO.setJson(json.toJSONString());
                    umcAuthoritySaveUserAuthReqBO.setRoleId(Long.valueOf(dicResult.getCode()));
                    UmcAuthoritySaveUserAuthRspBO umcAuthoritySaveUserAuthRspBO = this.authorityServiceHolder.getUmcExternalAuthorityUserService().saveUserAuth(umcAuthoritySaveUserAuthReqBO);
                    if (!umcAuthoritySaveUserAuthRspBO.getRespCode().equals("0000")) {
                        throw new UmcBusinessException("8888", "\u7528\u6237\u6388\u6743\u89d2\u8272\u5931\u8d25");
                    }
                }
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkSupplierInfoPOS(List<SupplierInfoPO> supplierInfoPOS, Integer count) {
        if (CollectionUtils.isEmpty(supplierInfoPOS) || !count.equals(supplierInfoPOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        supplierInfoPOS.stream().forEach(po -> {
            if (!po.getAuditStatusInsert().equals(0)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
        });
    }

    private void updateSupplierInfo(List<SupplierInfoPO> supplierInfoPOS, UmcSupAdmittanceAduitBusiReqBO reqBO) {
        Date auditTime = reqBO.getAuditTime();
        if (null == reqBO.getAuditTime()) {
            auditTime = new Date();
        }
        Date finalAuditTime = auditTime;
        supplierInfoPOS.stream().forEach(po -> {
            po.setAuditor(reqBO.getMemIdIn());
            po.setAuditStatusInsert(reqBO.getApprovalType());
            po.setRemark(reqBO.getApprovalReason());
            po.setAuditTime(finalAuditTime);
            po.setStatus(UmcCommConstant.SupplierOperStatus.USING);
            int resultChng = this.supplierInfoChngDAO.updateByPrimaryKey((SupplierInfoPO)po);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u4fee\u6539\u4f9b\u5e94\u5546\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
            }
            int result = this.supplierInfoDAO.updateByPrimaryKey((SupplierInfoPO)po);
            if (result < 1) {
                throw new UmcBusinessException("8888", "\u4fee\u6539\u4f9b\u5e94\u5546\u4fe1\u606f\u6e90\u8868\u5931\u8d25");
            }
        });
    }
}

