/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierCertificationChngMapper;
import com.tydic.umc.dao.SupplierCertificationMapper;
import com.tydic.umc.external.audit.bo.UmcExternalApprovalObjBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateInfoBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupCertificationAddBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupCertificationAddBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupCertificationAddBusiRspBO;
import com.tydic.umc.perf.common.SupplierCertificationPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcSupCertificationAddBusiService")
public class UmcSupCertificationAddBusiServiceImpl
implements UmcSupCertificationAddBusiService {
    @Autowired
    private SupplierCertificationMapper supplierCertificationMapper;
    @Autowired
    private SupplierCertificationChngMapper supplierCertificationChngMapper;
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String CALL_PRC_SYS_CODE;

    public UmcSupCertificationAddBusiRspBO addSupCertification(UmcSupCertificationAddBusiReqBO reqBO) {
        this.initParam(reqBO);
        UmcSupCertificationAddBusiRspBO busiRspBO = new UmcSupCertificationAddBusiRspBO();
        SupplierCertificationPO supplierCertification = new SupplierCertificationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)supplierCertification);
        SupplierCertificationPO supplierCertificationPO = new SupplierCertificationPO();
        supplierCertificationPO.setSupplierId(reqBO.getSupplierId());
        supplierCertificationPO.setStatusOut(Integer.valueOf(1));
        List<SupplierCertificationPO> result = this.supplierCertificationMapper.getListByCondition(supplierCertificationPO);
        if (result != null) {
            for (SupplierCertificationPO po : result) {
                if (po.getComCertNameId() != reqBO.getComCertNameId()) continue;
                throw new UmcBusinessException("8888", "\u8be5\u8ba4\u8bc1\u5df2\u5b58\u5728\uff01");
            }
        }
        Long authId = Sequence.getInstance().nextId();
        supplierCertification.setAuthId(authId);
        supplierCertification.setStatus(Integer.valueOf(0));
        int insert = this.supplierCertificationMapper.insert(supplierCertification);
        if (insert < 1) {
            throw new UmcBusinessException("8888", "\u8ba4\u8bc1\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        int insertChng = this.supplierCertificationChngMapper.insert(supplierCertification);
        if (insertChng < 1) {
            throw new UmcBusinessException("8888", "\u8ba4\u8bc1\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.CreateAuditOrder(reqBO, supplierCertification);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u8ba4\u8bc1\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void CreateAuditOrder(UmcSupCertificationAddBusiReqBO reqBO, SupplierCertificationPO supplierCertification) {
        UmcExternalNoTaskAuditCreateReqBO umcExternalNoTaskAuditCreateReqBO = new UmcExternalNoTaskAuditCreateReqBO();
        umcExternalNoTaskAuditCreateReqBO.setProcDefKey("SupCertificationAudit");
        umcExternalNoTaskAuditCreateReqBO.setSysCode(this.CALL_PRC_SYS_CODE);
        umcExternalNoTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateReqBO.setIsSaveCreateLog("1");
        ArrayList<UmcExternalNoTaskAuditCreateInfoBO> createBusiReqBO = new ArrayList<UmcExternalNoTaskAuditCreateInfoBO>();
        UmcExternalNoTaskAuditCreateInfoBO umcExternalNoTaskAuditCreateInfoBO = new UmcExternalNoTaskAuditCreateInfoBO();
        umcExternalNoTaskAuditCreateInfoBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateInfoBO.setObjType(UmcCommConstant.AuditObjType.SUP_CERTIFICATION_AUDIT);
        umcExternalNoTaskAuditCreateInfoBO.setObjNum("1");
        umcExternalNoTaskAuditCreateInfoBO.setRemark("\u4f9b\u5e94\u5546\u8ba4\u8bc1\u4fe1\u606f\u65b0\u589e");
        ArrayList<UmcExternalApprovalObjBO> approvalObjInfo = new ArrayList<UmcExternalApprovalObjBO>();
        UmcExternalApprovalObjBO umcExternalApprovalObjBO = new UmcExternalApprovalObjBO();
        umcExternalApprovalObjBO.setObjId(String.valueOf(supplierCertification.getAuthId()));
        umcExternalApprovalObjBO.setObjType(UmcCommConstant.AuditObjType.SUP_CERTIFICATION_AUDIT);
        approvalObjInfo.add(umcExternalApprovalObjBO);
        umcExternalNoTaskAuditCreateInfoBO.setApprovalObjInfo(approvalObjInfo);
        createBusiReqBO.add(umcExternalNoTaskAuditCreateInfoBO);
        umcExternalNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UmcExternalNoTaskAuditCreateRspBO umcExternalNoTaskAuditCreateRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditCreateService().noTaskAuditCreate(umcExternalNoTaskAuditCreateReqBO);
        if (!"0000".equals(umcExternalNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UmcBusinessException(umcExternalNoTaskAuditCreateRspBO.getRespCode(), umcExternalNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    private void initParam(UmcSupCertificationAddBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4f9b\u5e94\u5546Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getComCertNameId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4f01\u4e1a\u8ba4\u8bc1\u540d\u79f0id[comCertNameId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCriterion()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u7b26\u5408\u6807\u51c6[criterion]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getScope()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8ba4\u8bc1\u8303\u56f4[scope]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPastdue()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8bc1\u4e66\u5230\u671f\u65f6\u95f4[pastdue]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCertorg()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8ba4\u8bc1\u673a\u6784[certorg]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAccessory()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8bc1\u4e66\u626b\u63cf\u4ef6[accessory]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

