/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierCertificationChngMapper;
import com.tydic.umc.dao.SupplierCertificationMapper;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupCertificationAuditBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupCertificationAuditBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupCertificationAuditBusiRspBO;
import com.tydic.umc.perf.common.SupplierCertificationPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcSupCertificationAuditBusiService")
public class UmcSupCertificationAuditBusiServiceImpl
implements UmcSupCertificationAuditBusiService {
    @Autowired
    private SupplierCertificationMapper supplierCertificationMapper;
    @Autowired
    private SupplierCertificationChngMapper supplierCertificationChngMapper;
    @Autowired
    private AuditServiceHolder auditServiceHolder;

    public UmcSupCertificationAuditBusiRspBO dealUmcSupCertificationAudit(UmcSupCertificationAuditBusiReqBO reqBO) {
        SupplierCertificationPO supplierCertificationPO = new SupplierCertificationPO();
        supplierCertificationPO.setAuthIds(reqBO.getAuthIds());
        supplierCertificationPO.setObjType(UmcCommConstant.AuditObjType.SUP_CERTIFICATION_AUDIT);
        supplierCertificationPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        List<SupplierCertificationPO> supplierCertificationPOS = this.supplierCertificationChngMapper.getListTask(supplierCertificationPO);
        this.checkSupplierInfoPOS(supplierCertificationPOS, reqBO.getAuthIds().size());
        this.updateSupplierInfo(supplierCertificationPOS, reqBO);
        Integer auditResult = reqBO.getApprovalType().equals(1) ? 0 : 1;
        supplierCertificationPOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            ArrayList<Long> authIds = new ArrayList<Long>();
            authIds.add(po.getAuthId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(authIds);
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_CERTIFICATION_AUDIT));
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
        });
        UmcSupCertificationAuditBusiRspBO rspBO = new UmcSupCertificationAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkSupplierInfoPOS(List<SupplierCertificationPO> supplierCertificationPOS, Integer count) {
        if (CollectionUtils.isEmpty(supplierCertificationPOS) || !count.equals(supplierCertificationPOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        supplierCertificationPOS.stream().forEach(po -> {
            if (!po.getStatus().equals(0)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
        });
    }

    private void updateSupplierInfo(List<SupplierCertificationPO> supplierCertificationPOS, UmcSupCertificationAuditBusiReqBO reqBO) {
        Integer status = reqBO.getApprovalType().equals(1) ? 2 : 1;
        Date verifytime = reqBO.getVerifytime();
        if (null == verifytime) {
            verifytime = new Date();
        }
        Date finalVerifytime = verifytime;
        supplierCertificationPOS.stream().forEach(po -> {
            po.setVerifier(reqBO.getMemIdIn());
            po.setStatus(status);
            po.setExplainz(reqBO.getApprovalReason());
            po.setVerifytime(finalVerifytime);
            int resultChng = this.supplierCertificationChngMapper.updateById((SupplierCertificationPO)po);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u8ba4\u8bc1\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
            }
            int result = this.supplierCertificationMapper.updateById((SupplierCertificationPO)po);
            if (result < 1) {
                throw new UmcBusinessException("8888", "\u8ba4\u8bc1\u4fe1\u606f\u6e90\u8868\u5931\u8d25");
            }
        });
    }
}

