/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierInfoChngDAO;
import com.tydic.umc.dao.SupplierInfoDAO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupInfoModifyAuditBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupInfoModifyAuditBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupInfoModifyAuditBusiRspBO;
import com.tydic.umc.po.SupplierInfoPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcSupInfoModifyAuditBusiService")
public class UmcSupInfoModifyAuditBusiServiceImpl
implements UmcSupInfoModifyAuditBusiService {
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Autowired
    private SupplierInfoDAO supplierInfoDAO;
    @Autowired
    private SupplierInfoChngDAO supplierInfoChngDAO;

    public UmcSupInfoModifyAuditBusiRspBO dealUmcSupInfoModifyAudit(UmcSupInfoModifyAuditBusiReqBO reqBO) {
        SupplierInfoPO supplierInfoPO = new SupplierInfoPO();
        supplierInfoPO.setSupplierIds(reqBO.getSupplierIdList());
        supplierInfoPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        supplierInfoPO.setObjType(UmcCommConstant.AuditObjType.SUP_INFO_MODIFY_AUDIT);
        List<SupplierInfoPO> supplierInfoPOS = this.supplierInfoChngDAO.getListTask(supplierInfoPO);
        this.checkSupplierInfoPOS(supplierInfoPOS, reqBO.getSupplierIdList().size());
        this.updateSupplierInfo(supplierInfoPOS, reqBO);
        Integer auditResult = reqBO.getApprovalType() == 1 ? 0 : 1;
        supplierInfoPOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            ArrayList<Long> supplierIdList = new ArrayList<Long>();
            supplierIdList.add(po.getSupplierId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(supplierIdList);
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_INFO_MODIFY_AUDIT));
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
        });
        UmcSupInfoModifyAuditBusiRspBO rspBO = new UmcSupInfoModifyAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkSupplierInfoPOS(List<SupplierInfoPO> supplierInfoPOS, Integer count) {
        if (CollectionUtils.isEmpty(supplierInfoPOS) || !count.equals(supplierInfoPOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        supplierInfoPOS.stream().forEach(po -> {
            if (!po.getAuditStatusUpdate().equals(3)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u5ba1\u6838");
            }
        });
    }

    private void updateSupplierInfo(List<SupplierInfoPO> supplierInfoPOS, UmcSupInfoModifyAuditBusiReqBO reqBO) {
        Date auditTime = reqBO.getAuditTime();
        if (null == auditTime) {
            auditTime = new Date();
        }
        Date finalAuditTime = auditTime;
        supplierInfoPOS.stream().forEach(po -> {
            int result;
            po.setAuditor(reqBO.getMemIdIn());
            po.setAuditStatusUpdate(reqBO.getApprovalType());
            po.setRemark(reqBO.getApprovalReason());
            po.setAuditTime(finalAuditTime);
            int resultChng = this.supplierInfoChngDAO.updateByPrimaryKey((SupplierInfoPO)po);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u4fee\u6539\u4f9b\u5e94\u5546\u4fe1\u606f\u4fee\u6539\u8868\u5931\u8d25");
            }
            if (reqBO.getApprovalType().equals(1) && (result = this.supplierInfoDAO.updateByPrimaryKey((SupplierInfoPO)po)) < 1) {
                throw new UmcBusinessException("8888", "\u4fee\u6539\u4f9b\u5e94\u5546\u4fe1\u606f\u6e90\u8868\u5931\u8d25");
            }
        });
    }
}

