/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.PerformanceDissentChngMapper;
import com.tydic.umc.dao.PerformanceDissentMapper;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupPerformanceDissentAuditBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceDissentAuditBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceDissentAuditBusiRspBO;
import com.tydic.umc.po.PerformanceDissentPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcSupPerformanceDissentAuditBusiService")
public class UmcSupPerformanceDissentAuditBusiServiceImpl
implements UmcSupPerformanceDissentAuditBusiService {
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Autowired
    private PerformanceDissentMapper performanceDissentMapper;
    @Autowired
    private PerformanceDissentChngMapper performanceDissentChngMapper;

    public UmcSupPerformanceDissentAuditBusiRspBO dealUmcSupPerformanceDissentAudit(UmcSupPerformanceDissentAuditBusiReqBO reqBO) {
        PerformanceDissentPO performanceDissentPO = new PerformanceDissentPO();
        performanceDissentPO.setDissentIdList(reqBO.getDissentIdList());
        performanceDissentPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        performanceDissentPO.setObjType(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_DISSENT_AUDIT);
        List<PerformanceDissentPO> performanceDissentPOS = this.performanceDissentChngMapper.selectListTaskBy(performanceDissentPO);
        this.checkPerformanceDissent(performanceDissentPOS, reqBO.getDissentIdList().size());
        this.updatePerformanceDissent(performanceDissentPOS, reqBO);
        Integer auditResult = reqBO.getApprovalType().equals(1) ? 0 : 1;
        performanceDissentPOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalReason());
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_DISSENT_AUDIT));
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            ArrayList<Long> dissentIdList = new ArrayList<Long>();
            dissentIdList.add(po.getDissentId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(dissentIdList);
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
        });
        UmcSupPerformanceDissentAuditBusiRspBO rspBO = new UmcSupPerformanceDissentAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkPerformanceDissent(List<PerformanceDissentPO> performanceDissentPOS, Integer dissentIdCount) {
        if (CollectionUtils.isEmpty(performanceDissentPOS) || !dissentIdCount.equals(performanceDissentPOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        for (PerformanceDissentPO performanceDissentPO : performanceDissentPOS) {
            if (performanceDissentPO.getStatus().equals(0)) continue;
            throw new UmcBusinessException("8888", "\u4e1a\u7ee9\u5f02\u8bae\u4fe1\u606f\u72b6\u6001\u4e3a[\u5f85\u5904\u7406]\u624d\u80fd\u5ba1\u6838");
        }
    }

    private void updatePerformanceDissent(List<PerformanceDissentPO> performanceDissentPOS, UmcSupPerformanceDissentAuditBusiReqBO reqBO) {
        Integer approvalType = reqBO.getApprovalType();
        Integer status = approvalType.equals(1) ? 2 : 1;
        performanceDissentPOS.stream().forEach(performanceDissentPO -> {
            int result;
            performanceDissentPO.setStatus(status);
            performanceDissentPO.setProcessPerson(reqBO.getMemIdIn());
            performanceDissentPO.setProcessTime(new Date());
            performanceDissentPO.setDescription(reqBO.getApprovalReason());
            int resultChng = this.performanceDissentChngMapper.updateById((PerformanceDissentPO)performanceDissentPO);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u4e1a\u7ee9\u5f02\u8bae\u4fe1\u606f\u5904\u7406\u5931\u8d25");
            }
            if (reqBO.getApprovalType().equals(1) && (result = this.performanceDissentMapper.updateById((PerformanceDissentPO)performanceDissentPO)) < 1) {
                throw new UmcBusinessException("8888", "\u4e1a\u7ee9\u5f02\u8bae\u4fe1\u606f\u5904\u7406\u5931\u8d25");
            }
        });
    }
}

