/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.PerformanceChngMapper;
import com.tydic.umc.dao.PerformanceMapper;
import com.tydic.umc.external.audit.bo.UmcExternalApprovalObjBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateInfoBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupPerformanceInfoAddBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceInfoAddBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceInfoAddBusiRspBO;
import com.tydic.umc.po.PerformancePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcSupPerformanceInfoAddBusiService")
public class UmcSupPerformanceInfoAddBusiServiceImpl
implements UmcSupPerformanceInfoAddBusiService {
    @Autowired
    private PerformanceMapper performanceMapper;
    @Autowired
    private PerformanceChngMapper performanceChngMapper;
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String CALL_PRC_SYS_CODE;

    public UmcSupPerformanceInfoAddBusiRspBO addSupPerformanceInfo(UmcSupPerformanceInfoAddBusiReqBO reqBO) {
        this.initParam(reqBO);
        UmcSupPerformanceInfoAddBusiRspBO busiRspBO = new UmcSupPerformanceInfoAddBusiRspBO();
        PerformancePO performance = new PerformancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)performance);
        Long performanceId = Sequence.getInstance().nextId();
        performance.setPerformanceId(performanceId);
        if (performance.getSubmitDate() == null) {
            performance.setSubmitDate(new Date());
        }
        performance.setAuditStatus(UmcCommConstant.AuditStatus.WAIT);
        performance.setIsDel(UmcCommConstant.SupIsDelFlag.NO);
        int insert = this.performanceMapper.insert(performance);
        if (insert < 1) {
            throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u4e1a\u7ee9\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        int insertChng = this.performanceChngMapper.insert(performance);
        if (insertChng < 1) {
            throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u4e1a\u7ee9\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.CreateAuditOrder(reqBO, performance);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f9b\u5e94\u5546\u4e1a\u7ee9\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void CreateAuditOrder(UmcSupPerformanceInfoAddBusiReqBO reqBO, PerformancePO performance) {
        UmcExternalNoTaskAuditCreateReqBO umcExternalNoTaskAuditCreateReqBO = new UmcExternalNoTaskAuditCreateReqBO();
        umcExternalNoTaskAuditCreateReqBO.setProcDefKey("SupPerformanceInfo");
        umcExternalNoTaskAuditCreateReqBO.setSysCode(this.CALL_PRC_SYS_CODE);
        umcExternalNoTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateReqBO.setIsSaveCreateLog("1");
        ArrayList<UmcExternalNoTaskAuditCreateInfoBO> createBusiReqBO = new ArrayList<UmcExternalNoTaskAuditCreateInfoBO>();
        UmcExternalNoTaskAuditCreateInfoBO umcExternalNoTaskAuditCreateInfoBO = new UmcExternalNoTaskAuditCreateInfoBO();
        umcExternalNoTaskAuditCreateInfoBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateInfoBO.setObjType(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_INFO_AUDIT);
        umcExternalNoTaskAuditCreateInfoBO.setObjNum("1");
        umcExternalNoTaskAuditCreateInfoBO.setRemark("\u4f9b\u5e94\u5546\u4e1a\u7ee9\u4fe1\u606f\u65b0\u589e");
        ArrayList<UmcExternalApprovalObjBO> approvalObjInfo = new ArrayList<UmcExternalApprovalObjBO>();
        UmcExternalApprovalObjBO umcExternalApprovalObjBO = new UmcExternalApprovalObjBO();
        umcExternalApprovalObjBO.setObjId(String.valueOf(performance.getPerformanceId()));
        umcExternalApprovalObjBO.setObjType(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_INFO_AUDIT);
        approvalObjInfo.add(umcExternalApprovalObjBO);
        umcExternalNoTaskAuditCreateInfoBO.setApprovalObjInfo(approvalObjInfo);
        createBusiReqBO.add(umcExternalNoTaskAuditCreateInfoBO);
        umcExternalNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UmcExternalNoTaskAuditCreateRspBO umcExternalNoTaskAuditCreateRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditCreateService().noTaskAuditCreate(umcExternalNoTaskAuditCreateReqBO);
        if (!"0000".equals(umcExternalNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UmcBusinessException(umcExternalNoTaskAuditCreateRspBO.getRespCode(), umcExternalNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    private void initParam(UmcSupPerformanceInfoAddBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4f9b\u5e94\u5546id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPerformanceSource()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u7ee9\u6765\u6e90[performanceSource]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPerformanceType()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u7ee9\u7c7b\u522b[performanceType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPerformanceScope()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u7ee9\u8303\u56f4[performanceScope]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPerformanceDistrict()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u7ee9\u533a\u57df[performanceDistrict]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getProjectName()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u9879\u76ee\u540d\u79f0[projectName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContCode()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContName()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContData()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u5408\u540c\u7b7e\u8ba2\u65e5\u671f[contData]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContAmount()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u5408\u540c\u91d1\u989d[contAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOwnCompany()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u4e3b\u5355\u4f4d[ownCompany]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOwnCompanyWitn()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u4e1a\u4e3b\u5355\u4f4d\u8bc1\u660e\u4eba[ownCompanyWitn]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getWitnContWay()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8bc1\u660e\u4eba\u8054\u7cfb\u65b9\u5f0f[witnContWay]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContHompage()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u5408\u540c\u9996\u9875[contHompage]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBillNum()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u53d1\u7968\u53f7[billNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBillScanning()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u53d1\u7968\u626b\u63cf\u4ef6[billScanning]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

