/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.PerformanceChngMapper;
import com.tydic.umc.dao.PerformanceMapper;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupPerformanceInfoAuditBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceInfoAuditBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupPerformanceInfoAuditBusiRspBO;
import com.tydic.umc.po.PerformancePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcSupPerformanceInfoAuditBusiService")
public class UmcSupPerformanceInfoAuditBusiServiceImpl
implements UmcSupPerformanceInfoAuditBusiService {
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Autowired
    private PerformanceMapper performanceMapper;
    @Autowired
    private PerformanceChngMapper performanceChngMapper;

    public UmcSupPerformanceInfoAuditBusiRspBO dealUmcSupPerformanceInfoAudit(UmcSupPerformanceInfoAuditBusiReqBO reqBO) {
        PerformancePO performancePO = new PerformancePO();
        performancePO.setPerformanceIdList(reqBO.getPerformanceIdList());
        performancePO.setIsDel(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
        performancePO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        performancePO.setObjType(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_INFO_AUDIT);
        List<PerformancePO> performancePOS = this.performanceChngMapper.getListTaskByModel(performancePO);
        this.checkPerformancePOS(performancePOS, reqBO.getPerformanceIdList().size());
        this.updatePerformance(performancePOS, reqBO);
        Integer auditResult = reqBO.getApprovalType() == 1 ? 0 : 1;
        performancePOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalReason());
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_PERFORMANCE_INFO_AUDIT));
            ArrayList<Long> performanceIdList = new ArrayList<Long>();
            performanceIdList.add(po.getPerformanceId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(performanceIdList);
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
        });
        UmcSupPerformanceInfoAuditBusiRspBO rspBO = new UmcSupPerformanceInfoAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkPerformancePOS(List<PerformancePO> performancePOS, Integer count) {
        if (CollectionUtils.isEmpty(performancePOS) || !count.equals(performancePOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        performancePOS.stream().forEach(po -> {
            if (!po.getAuditStatus().equals(0)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a[\u5f85\u5ba1\u6838]\u7684\u4e1a\u7ee9\u4fe1\u606f\u624d\u80fd\u5ba1\u6838");
            }
        });
    }

    private void updatePerformance(List<PerformancePO> performancePOS, UmcSupPerformanceInfoAuditBusiReqBO reqBO) {
        Integer auditStatus = reqBO.getApprovalType().equals(1) ? 2 : 1;
        Date auditDate = reqBO.getAuditDate();
        if (null == reqBO.getAuditDate()) {
            auditDate = new Date();
        }
        Date finalAuditDate = auditDate;
        performancePOS.stream().forEach(po -> {
            int result;
            po.setAuditDate(finalAuditDate);
            po.setAuditorRemark(reqBO.getApprovalReason());
            po.setAuditStatus(auditStatus);
            po.setAuditor(reqBO.getMemIdIn());
            int resultChng = this.performanceChngMapper.updateByPrimaryKey((PerformancePO)po);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u4e1a\u7ee9\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
            if (reqBO.getApprovalType().equals(1) && (result = this.performanceMapper.updateByPrimaryKey((PerformancePO)po)) < 1) {
                throw new UmcBusinessException("8888", "\u4e1a\u7ee9\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
        });
    }
}

