/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierCertificationChngMapper;
import com.tydic.umc.dao.SupplierCertificationMapper;
import com.tydic.umc.perf.busi.supplier.UmcSupQryCertificationDetaiBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQryCertificationDetailBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQryCertificationDetailBusiRspBO;
import com.tydic.umc.perf.common.SupplierCertificationPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcSupQryCertificationDetaiBusiService")
public class UmcSupQryCertificationDetaiBusiServiceImpl
implements UmcSupQryCertificationDetaiBusiService {
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private SupplierCertificationMapper supplierCertificationMapper;
    @Autowired
    private SupplierCertificationChngMapper supplierCertificationChngMapper;

    public UmcSupQryCertificationDetailBusiRspBO qrySupCertificationDetail(UmcSupQryCertificationDetailBusiReqBO reqBO) {
        this.initParam(reqBO);
        UmcSupQryCertificationDetailBusiRspBO busiRspBO = new UmcSupQryCertificationDetailBusiRspBO();
        SupplierCertificationPO supplierCertificationPO = new SupplierCertificationPO();
        supplierCertificationPO.setAuthId(reqBO.getAuthId());
        Map comCertNameTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "COM_CERT_NAME_TYPE");
        SupplierCertificationPO supplierCertification = null;
        supplierCertification = null == reqBO.getQryType() || reqBO.getQryType().equals(UmcCommConstant.QryType.QRY_DEFAULT) ? this.supplierCertificationMapper.getModelBy(supplierCertificationPO) : this.supplierCertificationChngMapper.getModelBy(supplierCertificationPO);
        if (null == supplierCertification) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u8ba4\u8bc1\u4fe1\u606f\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        if (null != supplierCertification.getComCertNameId()) {
            busiRspBO.setComCertName((String)comCertNameTypeMap.get(supplierCertification.getComCertNameId()));
        }
        BeanUtils.copyProperties((Object)supplierCertification, (Object)busiRspBO);
        busiRspBO.setSubmitTime(supplierCertification.getSubmittime());
        busiRspBO.setVerifyTime(supplierCertification.getVerifytime());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u8ba4\u8bc1\u4fe1\u606f\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void initParam(UmcSupQryCertificationDetailBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuthId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8ba4\u8bc1ID[authId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

