/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.ohaotian.plugin.db.Page;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.common.SupplierCertificationBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierCertificationChngMapper;
import com.tydic.umc.dao.SupplierCertificationMapper;
import com.tydic.umc.dao.SupplierInfoDAO;
import com.tydic.umc.perf.busi.supplier.UmcSupQryCertificationListBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQryCertificationListBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQryCertificationListBusiRspBO;
import com.tydic.umc.perf.common.SupplierCertificationPO;
import com.tydic.umc.po.SupplierInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcSupQryCertificationListBusiService")
public class UmcSupQryCertificationListBusiServiceImpl
implements UmcSupQryCertificationListBusiService {
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private SupplierCertificationMapper supplierCertificationMapper;
    @Autowired
    private SupplierCertificationChngMapper supplierCertificationChngMapper;
    @Autowired
    private SupplierInfoDAO supplierInfoMapper;

    public UmcSupQryCertificationListBusiRspBO qrySupCertificationList(UmcSupQryCertificationListBusiReqBO reqBO) {
        UmcSupQryCertificationListBusiRspBO busiRspBO = new UmcSupQryCertificationListBusiRspBO();
        SupplierCertificationPO supplierCertificationPO = new SupplierCertificationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)supplierCertificationPO);
        ArrayList<SupplierCertificationBO> rows = new ArrayList<SupplierCertificationBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        Map comCertNameTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "COM_CERT_NAME_TYPE");
        List<SupplierCertificationPO> supplierCertificationList = null;
        supplierCertificationList = null == reqBO.getQryType() || reqBO.getQryType().equals(UmcCommConstant.QryType.QRY_DEFAULT) ? this.supplierCertificationMapper.getListPageByCondition(supplierCertificationPO, page) : this.supplierCertificationChngMapper.getListPageByCondition(supplierCertificationPO, page);
        if (null == supplierCertificationList) {
            busiRspBO.setPageNo(Integer.valueOf(0));
            busiRspBO.setTotal(Integer.valueOf(0));
            busiRspBO.setRecordsTotal(Integer.valueOf(0));
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u8ba4\u8bc1\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        for (SupplierCertificationPO po : supplierCertificationList) {
            SupplierCertificationBO supplierCertification = new SupplierCertificationBO();
            if (null != po.getAuthId()) {
                supplierCertification.setAuthId(po.getAuthId());
            }
            if (null != po.getSupplierId()) {
                supplierCertification.setSupplierId(po.getSupplierId());
                SupplierInfoPO supplierInfoPO = new SupplierInfoPO();
                if (null != supplierCertification.getSupplierId()) {
                    supplierInfoPO.setSupplierId(supplierCertification.getSupplierId());
                    SupplierInfoPO supplierInfo = this.supplierInfoMapper.selectByKey(supplierInfoPO);
                    if (null != supplierInfo) {
                        supplierCertification.setSupplierName(supplierInfo.getSupplierName());
                    }
                }
            }
            if (null != po.getComCertNameId()) {
                supplierCertification.setComCertNameId(po.getComCertNameId());
                supplierCertification.setComCertName((String)comCertNameTypeMap.get(po.getComCertNameId()));
            }
            if (null != po.getCriterion()) {
                supplierCertification.setCriterion(po.getCriterion());
            }
            if (null != po.getScope()) {
                supplierCertification.setScope(po.getScope());
            }
            if (null != po.getPastdue()) {
                supplierCertification.setPastdue(po.getPastdue());
            }
            if (null != po.getCertorg()) {
                supplierCertification.setCertorg(po.getCertorg());
            }
            if (null != po.getAccessory()) {
                supplierCertification.setAccessory(po.getAccessory());
            }
            if (null != po.getSubmitter()) {
                supplierCertification.setSubmitter(po.getSubmitter());
            }
            if (null != po.getSubmittime()) {
                supplierCertification.setSubmittime(po.getSubmittime());
            }
            if (null != po.getExplainz()) {
                supplierCertification.setExplainz(po.getExplainz());
            }
            if (null != po.getVerifier()) {
                supplierCertification.setVerifier(po.getVerifier());
            }
            if (null != po.getVerifytime()) {
                supplierCertification.setVerifytime(po.getVerifytime());
            }
            if (null != po.getStatus()) {
                supplierCertification.setStatus(po.getStatus());
            }
            rows.add(supplierCertification);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u8ba4\u8bc1\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }
}

