/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierQualifChngInfoMapper;
import com.tydic.umc.dao.SupplierQualifInfoMapper;
import com.tydic.umc.external.audit.bo.UmcExternalApprovalObjBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateInfoBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditCreateRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupQualificationAddBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQualificationAddBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQualificationAddBusiRspBO;
import com.tydic.umc.po.SupplierQualifInfoPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcSupQualificationAddBusiService")
public class UmcSupQualificationAddBusiServiceImpl
implements UmcSupQualificationAddBusiService {
    @Autowired
    private SupplierQualifInfoMapper supplierQualifInfoMapper;
    @Autowired
    private SupplierQualifChngInfoMapper supplierQualifChngInfoMapper;
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String CALL_PRC_SYS_CODE;

    public UmcSupQualificationAddBusiRspBO addSupQualification(UmcSupQualificationAddBusiReqBO reqBO) {
        this.initParam(reqBO);
        UmcSupQualificationAddBusiRspBO busiRspBO = new UmcSupQualificationAddBusiRspBO();
        SupplierQualifInfoPO supplierQualifInfo = new SupplierQualifInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)supplierQualifInfo);
        Long qualifId = Sequence.getInstance().nextId();
        supplierQualifInfo.setQualifId(qualifId);
        if (supplierQualifInfo.getSubmitTime() == null) {
            supplierQualifInfo.setSubmitTime(new Date());
        }
        supplierQualifInfo.setAuditStatus(UmcCommConstant.AuditStatus.WAIT);
        supplierQualifInfo.setIsDel(UmcCommConstant.SupIsDelFlag.NO);
        int insert = this.supplierQualifInfoMapper.insert(supplierQualifInfo);
        if (insert < 1) {
            throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        int insertChng = this.supplierQualifChngInfoMapper.insert(supplierQualifInfo);
        if (insertChng < 1) {
            throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.CreateAuditOrder(reqBO, supplierQualifInfo);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void CreateAuditOrder(UmcSupQualificationAddBusiReqBO reqBO, SupplierQualifInfoPO supplierQualifInfo) {
        UmcExternalNoTaskAuditCreateReqBO umcExternalNoTaskAuditCreateReqBO = new UmcExternalNoTaskAuditCreateReqBO();
        umcExternalNoTaskAuditCreateReqBO.setProcDefKey("SupQualificationAudit");
        umcExternalNoTaskAuditCreateReqBO.setSysCode(this.CALL_PRC_SYS_CODE);
        umcExternalNoTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateReqBO.setIsSaveCreateLog("1");
        ArrayList<UmcExternalNoTaskAuditCreateInfoBO> createBusiReqBO = new ArrayList<UmcExternalNoTaskAuditCreateInfoBO>();
        UmcExternalNoTaskAuditCreateInfoBO umcExternalNoTaskAuditCreateInfoBO = new UmcExternalNoTaskAuditCreateInfoBO();
        umcExternalNoTaskAuditCreateInfoBO.setCreateOperId(String.valueOf(reqBO.getMemIdIn()));
        umcExternalNoTaskAuditCreateInfoBO.setObjType(UmcCommConstant.AuditObjType.SUP_QUALIFICATION_AUDIT);
        umcExternalNoTaskAuditCreateInfoBO.setObjNum("1");
        umcExternalNoTaskAuditCreateInfoBO.setRemark("\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u65b0\u589e");
        ArrayList<UmcExternalApprovalObjBO> approvalObjInfo = new ArrayList<UmcExternalApprovalObjBO>();
        UmcExternalApprovalObjBO umcExternalApprovalObjBO = new UmcExternalApprovalObjBO();
        umcExternalApprovalObjBO.setObjId(String.valueOf(supplierQualifInfo.getQualifId()));
        umcExternalApprovalObjBO.setObjType(UmcCommConstant.AuditObjType.SUP_QUALIFICATION_AUDIT);
        approvalObjInfo.add(umcExternalApprovalObjBO);
        umcExternalNoTaskAuditCreateInfoBO.setApprovalObjInfo(approvalObjInfo);
        createBusiReqBO.add(umcExternalNoTaskAuditCreateInfoBO);
        umcExternalNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UmcExternalNoTaskAuditCreateRspBO umcExternalNoTaskAuditCreateRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditCreateService().noTaskAuditCreate(umcExternalNoTaskAuditCreateReqBO);
        if (!"0000".equals(umcExternalNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UmcBusinessException(umcExternalNoTaskAuditCreateRspBO.getRespCode(), umcExternalNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    private void initParam(UmcSupQualificationAddBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQualifNameId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8d44\u8d28\u540d\u79f0ID[qualifNameId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQualifRankId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8d44\u8d28\u7b49\u7ea7ID[qualifRankId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCertifCode()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8d44\u8d28\u8bc1\u4e66\u7f16\u53f7[certifCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCertifAgency()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u53d1\u8bc1\u673a\u6784[certifAgency]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCertifTime()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u53d1\u8bc1\u65f6\u95f4[certifTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getValidUntil()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u6709\u6548\u671f\u81f3[validUntil]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCertifScan()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u8bc1\u4e66\u626b\u63cf\u4ef6[certifScan]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

