/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.perf.busi.supplier;

import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.SupplierQualifChngInfoMapper;
import com.tydic.umc.dao.SupplierQualifInfoMapper;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditReqBO;
import com.tydic.umc.external.audit.bo.UmcExternalNoTaskAuditOrderAuditRspBO;
import com.tydic.umc.facde.AuditServiceHolder;
import com.tydic.umc.perf.busi.supplier.UmcSupQualificationAuditBusiService;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQualificationAuditBusiReqBO;
import com.tydic.umc.perf.busi.supplier.bo.UmcSupQualificationAuditBusiRspBO;
import com.tydic.umc.po.SupplierQualifInfoPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcSupQualificationAuditBusiService")
public class UmcSupQualificationAuditBusiServiceImpl
implements UmcSupQualificationAuditBusiService {
    @Autowired
    private SupplierQualifInfoMapper supplierQualifInfoMapper;
    @Autowired
    private SupplierQualifChngInfoMapper supplierQualifChngInfoMapper;
    @Autowired
    private AuditServiceHolder auditServiceHolder;
    private static Integer Sup_Qualification_Audit = 1;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String CALL_PRC_SYS_CODE;

    public UmcSupQualificationAuditBusiRspBO dealUmcSupQualificationAudit(UmcSupQualificationAuditBusiReqBO reqBO) {
        SupplierQualifInfoPO supplierQualifInfoPO = new SupplierQualifInfoPO();
        supplierQualifInfoPO.setQualifIdList(reqBO.getQualifIdList());
        supplierQualifInfoPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        supplierQualifInfoPO.setObjType(UmcCommConstant.AuditObjType.SUP_QUALIFICATION_AUDIT);
        List<SupplierQualifInfoPO> supplierQualifInfoPOS = this.supplierQualifChngInfoMapper.getListTask(supplierQualifInfoPO);
        this.checkSupplierQualifInfoPOS(supplierQualifInfoPOS, reqBO);
        this.updatePerformance(supplierQualifInfoPOS, reqBO);
        Integer auditResult = reqBO.getApprovalType() == 1 ? 0 : 1;
        supplierQualifInfoPOS.stream().forEach(po -> {
            UmcExternalNoTaskAuditOrderAuditReqBO umcExternalNoTaskAuditOrderAuditReqBO = new UmcExternalNoTaskAuditOrderAuditReqBO();
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalReason());
            umcExternalNoTaskAuditOrderAuditReqBO.setSysCode(this.CALL_PRC_SYS_CODE);
            umcExternalNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getMemIdIn()));
            umcExternalNoTaskAuditOrderAuditReqBO.setObjType(String.valueOf(UmcCommConstant.AuditObjType.SUP_QUALIFICATION_AUDIT));
            ArrayList<Long> qualifIdList = new ArrayList<Long>();
            qualifIdList.add(po.getQualifId());
            umcExternalNoTaskAuditOrderAuditReqBO.setObjId(qualifIdList);
            umcExternalNoTaskAuditOrderAuditReqBO.setStepId(po.getTacheCode());
            umcExternalNoTaskAuditOrderAuditReqBO.setAuditResult(auditResult);
            UmcExternalNoTaskAuditOrderAuditRspBO umcExternalNoTaskAuditOrderAuditRspBO = this.auditServiceHolder.getUmcExternalNoTaskAuditOrderAuditService().noTaskAuditOrderAudit(umcExternalNoTaskAuditOrderAuditReqBO);
            if (!"0000".equals(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new UmcBusinessException(umcExternalNoTaskAuditOrderAuditRspBO.getRespCode(), umcExternalNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
        });
        UmcSupQualificationAuditBusiRspBO rspBO = new UmcSupQualificationAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkSupplierQualifInfoPOS(List<SupplierQualifInfoPO> supplierQualifInfoPOS, UmcSupQualificationAuditBusiReqBO reqBO) {
        Integer count = reqBO.getQualifIdList().size();
        if (CollectionUtils.isEmpty(supplierQualifInfoPOS) || !count.equals(supplierQualifInfoPOS.size())) {
            throw new UmcBusinessException("8888", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        supplierQualifInfoPOS.stream().forEach(po -> {
            if (reqBO.getOperType().equals(1) && !po.getAuditStatus().equals(3)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u672a\u6838\u5b9e\u7684\u624d\u53ef\u5ba1\u6838");
            }
            if (reqBO.getOperType().equals(0) && !po.getAuditStatus().equals(0)) {
                throw new UmcBusinessException("8888", "\u5ba1\u6838\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\u7684\u624d\u80fd\u5ba1\u6838");
            }
        });
    }

    private void updatePerformance(List<SupplierQualifInfoPO> supplierQualifInfoPOS, UmcSupQualificationAuditBusiReqBO reqBO) {
        Integer auditStatus = null;
        auditStatus = reqBO.getOperType().equals(1) ? Integer.valueOf(reqBO.getApprovalType().equals(1) ? 2 : 1) : (reqBO.getApprovalType().equals(1) ? Integer.valueOf(2) : (reqBO.getApprovalType().equals(3) ? Integer.valueOf(3) : Integer.valueOf(1)));
        Date auditDate = reqBO.getAuditDate();
        if (null == reqBO.getAuditDate()) {
            auditDate = new Date();
        }
        Date finalAuditDate = auditDate;
        Integer finalAuditStatus = auditStatus;
        supplierQualifInfoPOS.stream().forEach(po -> {
            int result;
            po.setAuditDate(finalAuditDate);
            po.setAuditorRemark(reqBO.getApprovalReason());
            po.setAuditStatus(finalAuditStatus);
            po.setAuditor(reqBO.getMemIdIn());
            int resultChng = this.supplierQualifChngInfoMapper.updateByPrimaryKey((SupplierQualifInfoPO)po);
            if (resultChng < 1) {
                throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
            if (reqBO.getApprovalType().equals(1) && (result = this.supplierQualifInfoMapper.updateByPrimaryKey((SupplierQualifInfoPO)po)) < 1) {
                throw new UmcBusinessException("8888", "\u4f9b\u5e94\u5546\u8d44\u8d28\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
        });
    }
}

