/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.util;

import com.tydic.umc.util.BASE64DecodedMultipartFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.springframework.web.multipart.MultipartFile;

public class Base64 {
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] INV = new int[256];
    private static String CONTENT_TYPE = "data:img/jpg;base64";

    public static char[] getAlphabet() {
        return (char[])CHARS.clone();
    }

    public static char[] encodeToChar(String s) {
        try {
            return Base64.encodeToChar(s.getBytes("UTF-8"), false);
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public static char[] encodeToChar(byte[] arr) {
        return Base64.encodeToChar(arr, false);
    }

    public static char[] encodeToChar(byte[] arr, boolean lineSeparator) {
        int len;
        int n = len = arr != null ? arr.length : 0;
        if (len == 0) {
            return new char[0];
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destLen = cnt + (lineSeparator ? (cnt - 1) / 76 << 1 : 0);
        char[] dest = new char[destLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = CHARS[i >>> 18 & 0x3F];
            dest[d++] = CHARS[i >>> 12 & 0x3F];
            dest[d++] = CHARS[i >>> 6 & 0x3F];
            dest[d++] = CHARS[i & 0x3F];
            if (!lineSeparator || ++cc != 19 || d >= destLen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destLen - 4] = CHARS[i >> 12];
            dest[destLen - 3] = CHARS[i >>> 6 & 0x3F];
            dest[destLen - 2] = left == 2 ? CHARS[i & 0x3F] : 61;
            dest[destLen - 1] = 61;
        }
        return dest;
    }

    public byte[] decode(char[] arr) {
        int length = arr.length;
        if (length == 0) {
            return new byte[0];
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = arr[endx] == '=' ? (arr[endx - 1] == '=' ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (arr[76] == '\r' ? cnt / 78 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = INV[arr[sndx++]] << 18 | INV[arr[sndx++]] << 12 | INV[arr[sndx++]] << 6 | INV[arr[sndx++]];
            dest[d++] = (byte)(i >> 16);
            dest[d++] = (byte)(i >> 8);
            dest[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sndx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sndx <= endx - pad) {
                i |= INV[arr[sndx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    public static byte[] encodeToByte(String s) {
        try {
            return Base64.encodeToByte(s.getBytes("UTF-8"), false);
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public static byte[] encodeToByte(byte[] arr) {
        return Base64.encodeToByte(arr, false);
    }

    public static byte[] encodeToByte(byte[] arr, boolean lineSep) {
        int len;
        int n = len = arr != null ? arr.length : 0;
        if (len == 0) {
            return new byte[0];
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (lineSep ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = (byte)CHARS[i >>> 18 & 0x3F];
            dest[d++] = (byte)CHARS[i >>> 12 & 0x3F];
            dest[d++] = (byte)CHARS[i >>> 6 & 0x3F];
            dest[d++] = (byte)CHARS[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = (byte)CHARS[i >> 12];
            dest[destlen - 3] = (byte)CHARS[i >>> 6 & 0x3F];
            dest[destlen - 2] = left == 2 ? (int)CHARS[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static byte[] decode(byte[] arr) {
        int length = arr.length;
        if (length == 0) {
            return new byte[0];
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = arr[endx] == 61 ? (arr[endx - 1] == 61 ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (arr[76] == 13 ? cnt / 78 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = INV[arr[sndx++]] << 18 | INV[arr[sndx++]] << 12 | INV[arr[sndx++]] << 6 | INV[arr[sndx++]];
            dest[d++] = (byte)(i >> 16);
            dest[d++] = (byte)(i >> 8);
            dest[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sndx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sndx <= endx - pad) {
                i |= INV[arr[sndx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    public static String encodeToString(String s) {
        try {
            return new String(Base64.encodeToChar(s.getBytes("UTF-8"), false));
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public static String decodeToString(String s) {
        try {
            return new String(Base64.decode(s), "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public static String encodeToString(byte[] arr) {
        return new String(Base64.encodeToChar(arr, false));
    }

    public static String encodeToString(byte[] arr, boolean lineSep) {
        return new String(Base64.encodeToChar(arr, lineSep));
    }

    public static byte[] decode(String s) {
        int length = s.length();
        if (length == 0) {
            return new byte[0];
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = s.charAt(endx) == '=' ? (s.charAt(endx - 1) == '=' ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (s.charAt(76) == '\r' ? cnt / 78 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = INV[s.charAt(sndx++)] << 18 | INV[s.charAt(sndx++)] << 12 | INV[s.charAt(sndx++)] << 6 | INV[s.charAt(sndx++)];
            dest[d++] = (byte)(i >> 16);
            dest[d++] = (byte)(i >> 8);
            dest[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sndx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sndx <= endx - pad) {
                i |= INV[s.charAt(sndx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    public static MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            org.apache.commons.codec.binary.Base64 decoder = new org.apache.commons.codec.binary.Base64();
            byte[] b = new byte[]{};
            b = decoder.decode(baseStrs[0]);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            return new BASE64DecodedMultipartFile(b, CONTENT_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Arrays.fill(INV, -1);
        int iS = CHARS.length;
        for (int i = 0; i < iS; ++i) {
            Base64.INV[Base64.CHARS[i]] = i;
        }
        Base64.INV[61] = 0;
    }
}

