/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexadecimalUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HexadecimalUtils.class);
    private static final boolean IS_ERRORENABLED = LOGGER.isErrorEnabled();
    private static final Integer MAX_DIGITS = 64;

    public static String stringToFixHex16String(String needStrTransFixHex) {
        String hexStr;
        block8: {
            hexStr = HexadecimalUtils.stringToHex16String(needStrTransFixHex);
            if (StringUtils.isBlank((CharSequence)hexStr)) {
                if (IS_ERRORENABLED) {
                    LOGGER.error("\u9700\u8981\u8f6c\u6362\u4e3a64\u4f4d\u5b9a\u957f16\u8fdb\u5236\u7684\u5165\u53c2\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01\uff01\uff01\uff01\uff01");
                }
                return null;
            }
            if (hexStr.length() > MAX_DIGITS) {
                if (IS_ERRORENABLED) {
                    LOGGER.error("\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u5728\u8f6c\u6362\u4e3a64\u4f4d16\u8fdb\u5236\u683c\u5f0f\u65f6\u8d85\u957f\uff01\uff01\uff01\uff01\uff01");
                }
                return null;
            }
            if (hexStr.length() < MAX_DIGITS) {
                Integer randomLength = (MAX_DIGITS - hexStr.length()) / 2;
                String sources = "0123456789";
                SecureRandom random = null;
                try {
                    random = SecureRandom.getInstanceStrong();
                    StringBuilder flag = new StringBuilder();
                    for (int i = 0; i < randomLength - 1; ++i) {
                        flag.append(sources.charAt(random.nextInt(9)));
                    }
                    flag.append("$");
                    String fillHex = HexadecimalUtils.stringToHex16String(flag.toString());
                    hexStr = fillHex + hexStr;
                }
                catch (NoSuchAlgorithmException e) {
                    if (!IS_ERRORENABLED) break block8;
                    LOGGER.error("NoSuchAlgorithmException:{}", (Object)e.toString());
                }
            }
        }
        return hexStr;
    }

    private static String stringToHex16String(String needTransStr) {
        if (StringUtils.isBlank((CharSequence)needTransStr)) {
            if (IS_ERRORENABLED) {
                LOGGER.error("\u9700\u8981\u8f6c\u6362\u4e3a16\u8fdb\u5236\u7684\u5165\u53c2\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01\uff01\uff01\uff01\uff01");
            }
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < needTransStr.length(); ++i) {
            char ch = needTransStr.charAt(i);
            String s4 = Integer.toHexString(ch);
            str.append(s4.trim().toLowerCase());
        }
        return str.toString();
    }

    public static String hexStringToString(String needTransHexStr) {
        block8: {
            if (StringUtils.isBlank((CharSequence)needTransHexStr)) {
                if (IS_ERRORENABLED) {
                    LOGGER.error("\u4f20\u5165\u7684\u9700\u8981\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u768416\u8fdb\u5236\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01\uff01\uff01");
                }
                return null;
            }
            byte[] baKeyword = new byte[needTransHexStr.length() / 2];
            for (int i = 0; i < baKeyword.length; ++i) {
                try {
                    baKeyword[i] = (byte)(0xFF & Integer.parseInt(needTransHexStr.substring(i * 2, i * 2 + 2), 16));
                    continue;
                }
                catch (Exception e) {
                    if (IS_ERRORENABLED) {
                        LOGGER.error("\u5c0616\u8fdb\u5236\u8f6c\u6362\u4e3abyte\u6570\u7ec4\u51fa\u9519\uff01\uff01\uff01\uff01\uff01", (Throwable)e);
                    }
                    return null;
                }
            }
            try {
                needTransHexStr = new String(baKeyword, "UTF-8");
            }
            catch (Exception e) {
                if (!IS_ERRORENABLED) break block8;
                LOGGER.error("\u5c06byte\u6570\u7ec4\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u51fa\u9519\uff01\uff01\uff01\uff01\uff01", (Throwable)e);
            }
        }
        return needTransHexStr;
    }
}

