/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.util;

import com.tydic.umc.constant.UmcCommConstant;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String get16UUID() {
        byte[] outputByteArray;
        String uuid = UUID.randomUUID().toString();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] inputByteArray = uuid.getBytes();
            messageDigest.update(inputByteArray);
            outputByteArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        StringBuffer buf = new StringBuffer("");
        for (int offset = 0; offset < outputByteArray.length; ++offset) {
            int i = outputByteArray[offset];
            if (i < 0) {
                i += 256;
            }
            if (i < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(i));
        }
        return buf.toString().substring(8, 24);
    }

    public static String getFileSuffix(String fileName) {
        int indexSuffix = fileName.lastIndexOf(".");
        if (indexSuffix != -1) {
            return fileName.substring(indexSuffix, fileName.length());
        }
        return fileName;
    }

    public static Integer getPayType(String payMethod) {
        try {
            Integer tempPayMethod = Integer.parseInt(payMethod);
            if (tempPayMethod < 20 && tempPayMethod > 9) {
                return UmcCommConstant.PayType.WX_PAY;
            }
            if (tempPayMethod < 30 && tempPayMethod > 19) {
                return UmcCommConstant.PayType.ALI_PAY;
            }
        }
        catch (Exception e) {
            log.error("8888", (Object)"\u652f\u4ed8\u65b9\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        return UmcCommConstant.PayType.WX_PAY;
    }
}

