/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umcext.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathReqBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.service.SelectRolesByOrgTreePathBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.user.bo.ChangePwdIsOrNotReqBO;
import com.ohaotian.authority.user.bo.ChangePwdIsOrNotRspBO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.bo.SelectUserByStationAndOrgWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserByStationAndOrgWebRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoByOrgIdWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoByOrgIdWebRspBO;
import com.ohaotian.authority.user.bo.UserAuthReqBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.user.service.ChangePwdOfExpireService;
import com.ohaotian.authority.user.service.ResetPasswordService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthRolesService;
import com.ohaotian.authority.user.service.SelectUserByStationAndOrgWebService;
import com.ohaotian.authority.user.service.SelectUserInfoByOrgIdWebService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.tydic.umc.ability.bo.AuthorityUserInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"umc/authority/user"})
public class UmcAuthorityUserController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcAuthorityUserController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SelectRolesByOrgTreePathBusiService selectRolesByOrgTreePathBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SaveUserAuthService saveUserAuthService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private ResetPasswordService resetPasswordService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SelectUserInfoByOrgIdWebService selectUserInfoByOrgIdWebService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private SelectUserByStationAndOrgWebService selectUserByStationAndOrgWebService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private ChangePwdOfExpireService changePwdOfExpireService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH-GROUP-PROD")
    private ChangePwdByUserIdService changePwdByUserIdService;

    @RequestMapping(value={"/authUser"})
    public Object authUser(@RequestBody UserAuthReqBO userAuthReqBO) {
        List userOperateRoles = new ArrayList();
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            SelectRolesByOrgTreePathReqBO selectRolesByOrgTreePathReqBO = new SelectRolesByOrgTreePathReqBO();
            selectRolesByOrgTreePathReqBO.setOrgTreePath(userAuthReqBO.getManaOrgTreePath());
            SelectRolesByOrgTreePathRspBO select = this.selectRolesByOrgTreePathBusiService.select(selectRolesByOrgTreePathReqBO);
            userOperateRoles = select.getHasGrantRoles();
        } else {
            SelectUserOperateRolesReqBO operateRolesReqBO = new SelectUserOperateRolesReqBO();
            operateRolesReqBO.setPrarmUserId(userAuthReqBO.getPrarmUserId());
            SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(operateRolesReqBO);
            userOperateRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        }
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        orgDistributeRspBO.setCode("0");
        orgDistributeRspBO.setMessage("\u67e5\u8be2\u6210\u529f");
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/authUserCommit"})
    public Object authUserCommit(@RequestBody SaveUserRolesAuthReqBO saveUserRolesAuthReqBO) {
        if (StringUtils.isEmpty((CharSequence)saveUserRolesAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (saveUserRolesAuthReqBO.getMgrUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        saveUserRolesAuthReqBO.setUserId(saveUserRolesAuthReqBO.getMgrUserId());
        saveUserRolesAuthReqBO.setMgrUserId(null);
        this.saveUserAuthService.saveUserAuthService(saveUserRolesAuthReqBO);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "0");
        map.put("message", "\u63d0\u4ea4\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"/reset"})
    public Object reset(@RequestBody AuthorityUserInfoBO authorityUserInfoBO) {
        HashMap<String, String> map = new HashMap<String, String>();
        List userIds = authorityUserInfoBO.getUserIds();
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            map.put("code", "1");
            map.put("message", "\u5165\u53c2\u4e3a\u7a7a");
            return map;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bc6\u7801\u91cd\u7f6e\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)userIds));
        }
        this.resetPasswordService.resetPasswordByUserId(userIds);
        map.put("code", "0");
        map.put("message", "\u91cd\u7f6e\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"/queryUserByOrgOrStationCode"})
    public Object queryUserByOrgOrStationCode(@RequestBody AuthorityUserInfoBO authorityUserInfoBO) {
        Long orgId;
        HashMap<String, String> map = new HashMap<String, String>();
        if (authorityUserInfoBO == null) {
            map.put("code", "1");
            map.put("message", "\u5165\u53c2\u4e3a\u7a7a");
            return map;
        }
        Long l = orgId = authorityUserInfoBO.getOrgIdWeb() != null ? authorityUserInfoBO.getOrgIdWeb() : authorityUserInfoBO.getOrgId();
        if (StringUtils.isBlank((CharSequence)authorityUserInfoBO.getStationCode())) {
            SelectUserInfoByOrgIdWebReqBO selectUserInfoByOrgIdWebReqBO = new SelectUserInfoByOrgIdWebReqBO();
            selectUserInfoByOrgIdWebReqBO.setOrgId(orgId);
            SelectUserInfoByOrgIdWebRspBO rspBO = this.selectUserInfoByOrgIdWebService.selectUserInfoByOrgId(selectUserInfoByOrgIdWebReqBO);
            if (rspBO != null && rspBO.getCode() == null) {
                rspBO.setCode("0");
                rspBO.setMessage("\u67e5\u8be2\u6210\u529f");
            }
            return rspBO;
        }
        SelectUserByStationAndOrgWebReqBO selectUserByStationAndOrgWebReqBO = new SelectUserByStationAndOrgWebReqBO();
        selectUserByStationAndOrgWebReqBO.setOrgId(orgId);
        selectUserByStationAndOrgWebReqBO.setStationCode(authorityUserInfoBO.getStationCode());
        SelectUserByStationAndOrgWebRspBO rspBO1 = this.selectUserByStationAndOrgWebService.selectApproveUser(selectUserByStationAndOrgWebReqBO);
        if (rspBO1 != null && rspBO1.getCode() == null) {
            rspBO1.setCode("0");
            rspBO1.setMessage("\u67e5\u8be2\u6210\u529f");
        }
        return rspBO1;
    }

    @RequestMapping(value={"/changeInvalidPwd"})
    @BusiResponseBody
    public Object changeInvalidPwd(@RequestBody ChangePwdIsOrNotReqBO changePwdIsOrNotReqBO) {
        ChangePwdIsOrNotRspBO changePwdIsOrNotRspBO = this.changePwdOfExpireService.changePwd(changePwdIsOrNotReqBO);
        changePwdIsOrNotRspBO.setCode("0");
        changePwdIsOrNotRspBO.setMessage("\u6210\u529f");
        return changePwdIsOrNotRspBO;
    }

    @RequestMapping(value={"/changeUserPwd"})
    @BusiResponseBody
    public Object changeUserPwd(@RequestBody ChangePwdReqBO changePwdReqBO) {
        this.changePwdByUserIdService.changePasswordByUserId(changePwdReqBO);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "0");
        result.put("message", "\u4fee\u6539\u6210\u529f");
        return result;
    }
}

