/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umcext.controller.member;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.umcext.ability.member.UmcMemImpByExcelAbilityService;
import com.tydic.umcext.ability.member.bo.UmcMemImpByExcelAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcMemImpByExcelAbilityRspBO;
import com.tydic.umcext.controller.utils.ExcelUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"umc/mem/"})
public class UmcMemImpByExcelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemImpByExcelController.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @HSFConsumer(serviceVersion="2.0.0-HSF-PROD", serviceGroup="UMC_GROUP_PROD")
    private UmcMemImpByExcelAbilityService umcMemImpByExcelAbilityService;

    @PostMapping(value={"memImpByExcel"})
    public UmcMemImpByExcelAbilityRspBO memImpByExcel(MultipartFile file, UmcMemImpByExcelAbilityReqBO reqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("MultipartFile.Name={}", (Object)file.getOriginalFilename());
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            ExcelUtils.getExcelDate(file, data, title);
        }
        catch (Exception e) {
            e.printStackTrace();
            UmcMemImpByExcelAbilityRspBO rspBO = new UmcMemImpByExcelAbilityRspBO();
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        reqBO.setData(data);
        reqBO.setTitle(title);
        reqBO.setFileName(file.getOriginalFilename());
        if (null != reqBO.getOrgIdIn()) {
            reqBO.setAdmOrgId(reqBO.getOrgIdIn());
        }
        return this.umcMemImpByExcelAbilityService.memImpByExcel(reqBO);
    }

    @PostMapping(value={"welfareMemImpByExcel"})
    public UmcMemImpByExcelAbilityRspBO welfareMemImpByExcel(MultipartFile file, UmcMemImpByExcelAbilityReqBO reqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("MultipartFile.Name={}", (Object)file.getOriginalFilename());
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            ExcelUtils.getExcelDate(file, data, title);
        }
        catch (Exception e) {
            e.printStackTrace();
            UmcMemImpByExcelAbilityRspBO rspBO = new UmcMemImpByExcelAbilityRspBO();
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("excel\u89e3\u91ca\u5931\u8d25");
            return rspBO;
        }
        reqBO.setData(data);
        reqBO.setTitle(title);
        reqBO.setFileName(file.getOriginalFilename());
        if (null != reqBO.getOrgIdIn()) {
            reqBO.setAdmOrgId(reqBO.getOrgIdIn());
        }
        return this.umcMemImpByExcelAbilityService.welfareMemImpByExcel(reqBO);
    }
}

