/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.usc.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.usc.api.ability.UscDownloadGoodsImportTemplateAbilityService;
import com.tydic.usc.api.ability.bo.UscDownloadGoodsImportTemplateAbilityRspBO;
import com.tydic.usc.controller.utils.ExcelUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/usc/shoppingcart"})
public class UscDownloadGoodsImportTemplateBusiServiceController {
    private static final Logger log = LoggerFactory.getLogger(UscDownloadGoodsImportTemplateBusiServiceController.class);
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="USC_GROUP_DEV")
    private UscDownloadGoodsImportTemplateAbilityService uscDownloadGoodsImportTemplateAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadGoodsImportTemplate"})
    public void getItemExcel(HttpServletResponse response) {
        UscDownloadGoodsImportTemplateAbilityRspBO rspBO = this.uscDownloadGoodsImportTemplateAbilityService.downloadGoodsImportTemplate();
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(rspBO.getData(), "\u7535\u5b50\u8d85\u5e02\u6807\u51c6\u7248\u5546\u54c1\u5bfc\u5165\u6a21\u7248", false, null);
        BufferedOutputStream bufferedOutPut = null;
        ServletOutputStream output = null;
        this.setExcelHead(response, "importGoods.xlsx");
        try {
            output = response.getOutputStream();
            bufferedOutPut = new BufferedOutputStream((OutputStream)output);
            workbook.write((OutputStream)bufferedOutPut);
            bufferedOutPut.flush();
            bufferedOutPut.close();
            this.close(bufferedOutPut, (OutputStream)output);
        }
        catch (IOException e) {
            try {
                log.error("excel\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                this.close(bufferedOutPut, (OutputStream)output);
            }
            catch (Throwable throwable) {
                this.close(bufferedOutPut, (OutputStream)output);
                throw throwable;
            }
        }
    }

    private void setExcelHead(HttpServletResponse response, String realName) {
        response.setHeader("Content-Disposition", "attachment;filename=" + realName);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private void close(BufferedOutputStream bufferedOutPut, OutputStream output) {
        IOUtils.closeQuietly((Closeable)bufferedOutPut);
        IOUtils.closeQuietly((Closeable)output);
    }
}

