/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.usc.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.usc.api.ability.UscGoodsExportAbilityService;
import com.tydic.usc.api.ability.bo.UscGoodsExportAbilityReqBO;
import com.tydic.usc.api.ability.bo.UscGoodsExportAbilityRspBO;
import com.tydic.usc.controller.utils.ExcelUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/usc/shoppingcart"})
public class UscGoodsExportAbilityServiceController {
    private static final Logger log = LoggerFactory.getLogger(UscGoodsExportAbilityServiceController.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @HSFConsumer(serviceVersion="2.0-SNAPSHOT", serviceGroup="USC_GROUP_DEV")
    private UscGoodsExportAbilityService uscGoodsExportAbilityService;
    @Autowired
    private FileClient fileClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportGoods"})
    public UscGoodsExportAbilityRspBO getItemExcel(@RequestBody UscGoodsExportAbilityReqBO reqBO, HttpServletResponse response) {
        UscGoodsExportAbilityRspBO rspBO;
        if (log.isDebugEnabled()) {
            log.debug("\u8d2d\u7269\u8f66\u5546\u54c1\u5bfc\u51fa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)(rspBO = this.uscGoodsExportAbilityService.exportGoods(reqBO)).getData())) {
            return rspBO;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8d2d\u7269\u8f66\u5546\u54c1\u5bfc\u51fa\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2Data\u503c\uff1a" + rspBO.getData().toString());
        }
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(rspBO.getData(), "\u7535\u5b50\u8d85\u5e02\u6807\u51c6\u7248\u5546\u54c1\u5bfc\u51fa", true, rspBO.getTotalPrice());
        BufferedOutputStream bufferedOutPut = null;
        ByteArrayOutputStream output = null;
        this.setExcelHead(response, "exportGoods.xlsx");
        String uploadPath = "usc";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            output = new ByteArrayOutputStream();
            workbook.write((OutputStream)output);
            byte[] b = output.toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            output.flush();
        }
        catch (IOException e) {
            log.error("excel\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.close(bufferedOutPut, output);
        }
        return rspBO;
    }

    private void setExcelHead(HttpServletResponse response, String realName) {
        response.setHeader("Content-Disposition", "attachment;filename=" + realName);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private void close(BufferedOutputStream bufferedOutPut, OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }
}

