/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.usc.controller;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.usc.api.ability.UscGoodsExportAbilityService;
import com.tydic.usc.api.ability.bo.UscGoodsExportAbilityReqBO;
import com.tydic.usc.api.ability.bo.UscGoodsExportAbilityRspBO;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/usc/shoppingcart"})
public class UscGoodsExportAbilityServiceController {
    private static final Logger log = LoggerFactory.getLogger(UscGoodsExportAbilityServiceController.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private UscGoodsExportAbilityService uscGoodsExportAbilityService;
    @Autowired
    private FileClient fileClient;

    @RequestMapping(value={"/exportGoods"})
    public UscGoodsExportAbilityRspBO getItemExcel(@RequestBody UscGoodsExportAbilityReqBO reqBO, HttpServletResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("\u8d2d\u7269\u8f66\u5546\u54c1\u5bfc\u51fa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        UscGoodsExportAbilityRspBO rspBO = this.uscGoodsExportAbilityService.exportGoods(reqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8d2d\u7269\u8f66\u5546\u54c1\u5bfc\u51fa\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + rspBO.toString());
        }
        return rspBO;
    }

    private void setExcelHead(HttpServletResponse response, String realName) {
        response.setHeader("Content-Disposition", "attachment;filename=" + realName);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private void close(BufferedOutputStream bufferedOutPut, OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }
}

