package com.tydic.utils.npc.aop;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.utils.npc.bo.NpcBaseRspBo;
import com.tydic.utils.npc.bo.NpcRpcControllerReqBo;
import com.tydic.utils.npc.bo.NpcRpcControllerRspBo;
import lombok.extern.ohaotian.TempServiceInfo;
import lombok.extern.slf4j.Slf4j;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;

/**
 * 标题：NpcNativeRpcCallAdvice
 * 说明：本机RPC调用切面
 * 时间：2021/9/2 16:11
 *
 * @author 何秀全
 */
@Slf4j
public class NpcNativeRpcCallAdvice implements MethodInterceptor {
    /**
     * 是否启用本机RPC调用
     */
    private final boolean isCall;
    /**
     * rpc泛化调用controller路径
     */
    private final String rpcCallUrl;

    public NpcNativeRpcCallAdvice(boolean isCall, String rpcCallUrl) {
        this.isCall = isCall;
        this.rpcCallUrl = rpcCallUrl;
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        //判断是否启用本机RPC调用
        if (isCall) {
            //获取调用服务方法
            Method method = methodInvocation.getMethod();
            //获取 类
            Class<?> aClass = method.getDeclaringClass();
            TempServiceInfo tempAnnotation = aClass.getAnnotation(TempServiceInfo.class);
            //判断该服务是否为RPC服务
            if (null != tempAnnotation) {
                //调用服务器 RPC调用controller
                NpcRpcControllerReqBo reqBo = new NpcRpcControllerReqBo();
                reqBo.setInterClass(aClass.getName());
                reqBo.setMethod(method.getName());
                reqBo.setData(methodInvocation.getArguments()[0]);
                String reqBoJson = JSON.toJSONString(reqBo);
                HttpResponse response = HttpRequest.post(rpcCallUrl).body(reqBoJson).timeout(60000).execute();
                String responseBody;
                //Http请求不成功
                if (HttpStatus.HTTP_OK != response.getStatus()) {
                    String failureDesc = "调用服务器RPC ControllerHttp请求失败，状态码为：" + response.getStatus() + "；请求入参：" + reqBoJson + "；请求地址：" + rpcCallUrl;
                    log.info(failureDesc);
                    NpcBaseRspBo baseRspBo = new NpcBaseRspBo();
                    baseRspBo.setRespCode("8888");
                    baseRspBo.setRespDesc(failureDesc);
                    baseRspBo.setCode("1");
                    baseRspBo.setMessage(failureDesc);
                    responseBody = JSON.toJSONString(baseRspBo);
                } else {
                    responseBody = response.body();
                }
                NpcRpcControllerRspBo rspBo = JSON.parseObject(responseBody, NpcRpcControllerRspBo.class);
                AnnotatedType annotatedReturnType = methodInvocation.getMethod().getAnnotatedReturnType();
                return JSON.parseObject(JSONObject.toJSONString(rspBo.getData()), annotatedReturnType.getType());
            }
        }

        //正常调用服务返回
        return methodInvocation.proceed();
    }
}
