package com.tydic.utils.npc.config;

import com.tydic.utils.npc.aop.NpcNativeRpcCallAdvice;
import com.tydic.utils.npc.properties.NpcNativeProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：NpcConfigurableAdvisorConfig
 * 说明：本机RPC调用切面配置
 * 时间：2021/9/3 15:02
 *
 * @author 何秀全
 */
@Slf4j
@Configuration
public class NpcConfigurableAdvisorConfig {
    /**
     * 默认本机RPC切点位置
     */
    private static final String DEFAULT_NATIVE_RPC_PACKAGE = "com.tydic.utils.npc.aaa";
    /**
     * 本机RPC切点包路径分隔符
     */
    private static final String NATIVE_RPC_PACKAGE_DELIMITER = ",";
    /**
     * 本机RPC调用配置项
     */
    private final NpcNativeProperties npcNativeProperties;

    public NpcConfigurableAdvisorConfig(NpcNativeProperties npcNativeProperties) {
        this.npcNativeProperties = npcNativeProperties;
    }

    @Bean
    public NpcNativeProperties npcNativeProperties() {
        return new NpcNativeProperties();
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurableAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        //组装切点规则
        StringBuilder expressionBuilder = null;
        if (npcNativeProperties.getIsCall() && !DEFAULT_NATIVE_RPC_PACKAGE.equals(npcNativeProperties.getPointcutPackage())) {
            if (npcNativeProperties.getPointcutPackage().contains(NATIVE_RPC_PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit = npcNativeProperties.getPointcutPackage().split(NATIVE_RPC_PACKAGE_DELIMITER);
                for (String nativeRpcPackageString : nativeRpcPackageSplit) {
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                    } else {
                        expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                    }
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(npcNativeProperties.getPointcutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        advisor.setAdvice(new NpcNativeRpcCallAdvice(npcNativeProperties.getIsCall(), npcNativeProperties.getRpcCallUrl()));
        log.info("本机RPC调用切面配置完成，是否启用本机RPC调用：{}，RPC ControllerUrl：{}，切点规则为：{}", npcNativeProperties.getIsCall(), npcNativeProperties.getRpcCallUrl(), expression);
        return advisor;
    }
}
