package com.tydic.utils.npc.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 标题：NpcRpcProperties
 * 说明：本机RPC调用配置项
 * 时间：2021/9/4 15:13
 *
 * @author 何秀全
 */
@Data
@ConfigurationProperties(prefix = "npc.native")
public class NpcNativeProperties {
    /**
     * 是否启用本机RPC调用
     * 默认值：true
     */
    private Boolean isCall;
    /**
     * 本机RPC切点包路径，多个使用英文逗号[,]分隔
     * 默认值：com.tydic.utils.npc.aaa
     */
    private String pointcutPackage;
    /**
     * RPC服务器地址
     * 默认值：http://127.0.0.1:11050
     */
    private String serverAddress;
    /**
     * RPC ControllerUrl地址
     * 默认值：/npc/native/noauth/rpc
     */
    private String urlSuffix;

    public String getRpcCallUrl() {
        return serverAddress + urlSuffix;
    }
}
