/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.data.ItemInstance;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.webservice.MessageInstance;
import org.activiti.engine.impl.bpmn.webservice.Operation;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class WebServiceActivityBehavior
extends AbstractBpmnActivityBehavior {
    public static final String CURRENT_MESSAGE = "org.activiti.engine.impl.bpmn.CURRENT_MESSAGE";
    protected Operation operation;
    protected IOSpecification ioSpecification;
    protected List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    protected List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();

    public void addDataInputAssociation(AbstractDataAssociation dataAssociation) {
        this.dataInputAssociations.add(dataAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataAssociation) {
        this.dataOutputAssociations.add(dataAssociation);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        try {
            String firstDataOutputName;
            MessageInstance message;
            if (this.ioSpecification != null) {
                this.ioSpecification.initialize(execution);
                ItemInstance inputItem = (ItemInstance)execution.getVariable(this.ioSpecification.getFirstDataInputName());
                message = new MessageInstance(this.operation.getInMessage(), inputItem);
            } else {
                message = this.operation.getInMessage().createInstance();
            }
            execution.setVariable(CURRENT_MESSAGE, message);
            this.fillMessage(message, execution);
            ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
            MessageInstance receivedMessage = this.operation.sendMessage(message, processEngineConfig.getWsOverridenEndpointAddresses());
            execution.setVariable(CURRENT_MESSAGE, receivedMessage);
            if (this.ioSpecification != null && (firstDataOutputName = this.ioSpecification.getFirstDataOutputName()) != null) {
                ItemInstance outputItem = (ItemInstance)execution.getVariable(firstDataOutputName);
                outputItem.getStructureInstance().loadFrom(receivedMessage.getStructureInstance().toArray());
            }
            this.returnMessage(receivedMessage, execution);
            execution.setVariable(CURRENT_MESSAGE, null);
            this.leave(execution);
        }
        catch (Exception exc) {
            BpmnError error = null;
            for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof BpmnError)) continue;
                error = (BpmnError)cause;
                break;
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, execution);
            }
            throw exc;
        }
    }

    private void returnMessage(MessageInstance message, ActivityExecution execution) {
        for (AbstractDataAssociation dataAssociation : this.dataOutputAssociations) {
            dataAssociation.evaluate(execution);
        }
    }

    private void fillMessage(MessageInstance message, ActivityExecution execution) {
        for (AbstractDataAssociation dataAssociation : this.dataInputAssociations) {
            dataAssociation.evaluate(execution);
        }
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }
}

