package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/15 9:20
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCreateOrderServiceRspSaleOrderBo implements Serializable {

    private static final long serialVersionUID = 3392668845085791004L;

    /**
     * 销售单id
     */
    private Long saleOrderId;
    
    
    /**
     * 订单id
     */
    private Long orderId;
    

    /**
     * 销售单编号
     */
    private String saleOrderNo;

    /**
     * 订单来源  1 自营单品   2 电商导入   3 协议生成
     */
    private Integer orderSource;

    /**
     * 采购方下单人用户id
     */
    private String purUserId;

    /**
     * 采购方下单人真实姓名
     */
    private String purName;

    /**
     * 采购方下单人登录名
     */
    private String purUserName;

    /**
     * 供应商id
     */
    private String supId;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 供应商名称
     */
    private String supName;

    /**
     * 供应商联系人
     */
    private String supRelaName;

    /**
     * 供应商联系电话
     */
    private String supRelaMobile;

    /**
     * 运营单位机构id
     */
    private String proId;

    /**
     * 运营单位机构编码
     */
    private String proNo;

    /**
     * 运营机构名称
     */
    private String proName;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 明细信息
     */
    private List<UocCreateOrderServiceRspSaleOrderItemBo> itemBoList;

    /**
     * 协议id
     */
    private String agrId;

    /**
     * 付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付
     */
    private Integer payType;
    /**
     * 结算模式
     */
    private Integer modelSettle;

    //销售单状态
    private String saleOrderState;
    /**
     * 是否代管供应商：1是，0否
     */
    private Integer isEscrowSup;
    /**
     * 协议类型：框架协议/单采合同
     */
    private Integer agrType;
    /**
     * 发货单id(单价合同)
     */
    private List<Long> shipOrderIds;
    /**
     * 验收单id(单价合同)
     */
    private Long inspOrderId;
    /**
     * 竞价单id
     */
    private Long elbId;
    /**
     * 预算id
     */
    private Long budgetId;
    /**
     * 预算编号
     */
    private String budgetCode;
    /**
     * 预算名称
     */
    private String budgetName;
    /**
     * 采购方公司id
     */
    private String purCompanyId;
    /**
     * 订单失败原因
     */
    private String failReason;
}


