package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @description 外部系统接口调用日志插入领域服务入参
 * @author Luokan
 * @date 2022/12/8
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocAddOrderInterLogReqBO extends BaseReqBo {
	private static final long serialVersionUID = 977152694600888320L;

	//id//
	private Long id;

	//单据id                          单据类型为1=订单时，不填//
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他//
	private Integer objType;

	//订单id//
	private Long orderId;

	//接口流水//
	private String interSn;

	//接口编码//
	private String interCode;

	//流程正反向标志             1 正向             2 反向//
	private Integer flowFlag;

	//入参报文//
	private String inContent;

	//出参报文//
	private String outContent;

	//调用次数//
	private Integer callCount;

	//调用时间//
	private Date callTime;

	//远端返回时间//
	private Date retTime;

	//调用状态//
	private String callState;

	//异常编码//
	private String errCode;

	//异常描述//
	private String errDetail;

	//创建时间//
	private Date createTime;

	//创建工号//
	private String createLoginId;
}
