package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 标题:UocCreateOrderServiceReqPayConfSupBo
 * 说明:协议支付配置
 * 时间:2022/2/23 19:57
 * 作者:田桂银
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCreateOrderServiceReqArgPayConfSupBo implements Serializable {

    private static final long serialVersionUID = -6985215576971697872L;


    /**
     * 协议id
     */
    private String agrId;
    /**
     * 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
     */
    private Integer adjustPrice;
    /**
     * 协议经办人id（配送专责）
     */
    private String proDeliveryId;
    /**
     *协议经办人名字（配送专责）
     */
    private String proDeliveryName;
    /**
     *协议数据id
     */
    private Long agrDataId;

    /**
     * 协议支付配置
     */
    private List<UocCreateOrderServiceReqPayConfBo> confBos;
    
    /**
     *合同号
     */
    private String relCode;
    /**
     *合同名称
     */
    private String relName;
    
    //项目类型（1:物资 2:工程 3:服务）
    private Integer agreementVariety;
    //项目类型（1:物资 2:工程 3:服务）
    private String agreementVarietyStr;
    //合同来源类别6:原始合同 7:续约合同 8:补充合同
    private Integer agrSrc;
    private String agrSrcStr;
    /**
     * 协议类型：框架协议/单采合同
     */
    private Integer agrType;
    /**
     * 是否代管供应商：1是，0否
     */
    private Integer isEscrowSup;
}


