package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocCancelSaleOrderServiceReqBo
 * 说明:销售单取消 入参
 * 时间:2022/2/25 10:32
 * 作者:田坤林
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocCancelSaleOrderServiceReqBo extends BaseReqBo {
    private static final long serialVersionUID = 1705673384602921901L;

	/**
	 * 订单id
	 */
	private Long orderId;

	/**
	 * 销售单id
	 */
	private Long saleOrderId;

	/**
	 * 取消原因
	 */
	private String cancelReason;

	//取消原因标识，0用户主动取消，1审批时限自动取消，2审批驳回取消，3供应商主动取消，4电商消息主动取消
	private Integer cancelReasonFlag;

	/**
	 * 附件
	 */
	private List<UocBaseOrderAccessoryAddBo> accessoryAddBoList;

	/**
	 * 纵向扩展数据 更新
	 */
	private List<UocBaseExtParallelEditBo> extEditList;

	/**
	 * 纵向拓展信息 删除
	 */
	private List<UocBaseExtParallelDeleteBo> extDeleteList;

	private Long userId;
	private String name;
}
