package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocDealFailedOrderTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈预算扣减失败处理服务 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
@Slf4j
public class UocDealFailedOrderServiceImpl implements UocDealFailedOrderService{
    @Autowired
    private UocDealFailedOrderTransaction uocDealFailedOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocDealFieldOrderRspBo dealFailedOrder(UocDealFieldOrderReqBo reqBo) {
        UocDealFieldOrderRspBo rspBo = uocDealFailedOrderTransaction.dealFailedOrder(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealFieldOrderReqBo reqBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
