/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleGoodsAfterTakeTypeBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemPlanBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemShipAdress;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItemPlan;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAddressBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSaleOrderModelImpl
implements IUocSaleOrderModel {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderModelImpl.class);
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;
    @Autowired
    private UocOrderRepository uocOrderRepository;
    @Value(value="${isLimitPrice:true}")
    private boolean limitPrice;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        List<UocOrderAccessory> saleOrderAccessoryList;
        List<UocSaleOrderMap> saleOrderMapList;
        this.validateCreateArg(saleOrderDo);
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderNo())) {
            saleOrderDo.setSaleOrderNo("saleOrderNo");
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderId())) {
            saleOrderDo.setSaleOrderId(IdUtil.nextId());
        }
        if (null == saleOrderDo.getCreateTime()) {
            saleOrderDo.setCreateTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderState())) {
            saleOrderDo.setSaleOrderState(null);
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderItems().get(0).getPlanId())) {
            saleOrderDo.setPurchaseMode(UocDicConstant.PURCHASE_MODE.PLAN);
        }
        if (null != saleOrderDo.getSaleOrderItems().get(0).getAgrBo()) {
            saleOrderDo.setContractNo(saleOrderDo.getSaleOrderItems().get(0).getAgrBo().getContractNo());
        }
        if (ObjectUtil.isNotEmpty(saleOrderMapList = saleOrderDo.getSaleOrderMapList())) {
            Map<String, UocSaleOrderMap> baseExtendFieldBoMap = saleOrderMapList.stream().collect(Collectors.toMap(UocSaleOrderMap::getFieldCode, e -> e));
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setOrderId(saleOrderDo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList = saleOrderDo.getSaleOrderAccessoryList())) {
            for (UocOrderAccessory accessory : saleOrderAccessoryList) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
        this.setSaleItems(saleOrderDo);
        this.setAfterTakeType(saleOrderDo);
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId())) {
                saleOrderDo.setManagementOrgId(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId());
                saleOrderDo.setManagementOrgName(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgName());
            }
        } else {
            UocSaleStakeholderQryBo qryStakeHolder = new UocSaleStakeholderQryBo();
            qryStakeHolder.setStakeholderId(saleOrderDo.getStakeholderId());
            UocSaleStakeholder saleOrderStakeholder = this.uocSaleOrderRepository.getSaleOrderStakeholder(qryStakeHolder);
            if (ObjectUtil.isNotEmpty((Object)saleOrderStakeholder)) {
                saleOrderDo.setManagementOrgId(saleOrderStakeholder.getSupId());
                saleOrderDo.setManagementOrgName(saleOrderStakeholder.getSupName());
            }
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            this.setSaleItemShipAddress(saleOrderDo);
            if (UocConstant.AgrType.PRICE.equals(saleOrderDo.getSaleOrderItems().get(0).getAgrBo().getAgrType())) {
                this.createShipAndInspInfo(saleOrderDo);
            }
        }
        return this.uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void createShipAndInspInfo(UocSaleOrderDo saleOrderDo) {
        saleOrderDo.setSaleOrderState("XS_YS_YS");
        ArrayList<UocShipOrderDo> shipOrderList = new ArrayList<UocShipOrderDo>();
        Map saleOrderItemMap = saleOrderDo.getSaleOrderItems().stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, Function.identity()));
        Map<Long, List<UocSaleItemShipAdress>> contactAddressMap = saleOrderDo.getSaleItemShipAdressList().stream().collect(Collectors.groupingBy(UocSaleItemShipAdress::getContactId));
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        Long inspOrderId = IdUtil.nextId();
        createInspOrderDo.setOrderId(saleOrderDo.getOrderId());
        createInspOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        createInspOrderDo.setInspOrderId(inspOrderId);
        createInspOrderDo.setInspOrderNo(this.getInspOrderNo());
        createInspOrderDo.setInspOrderState("YS_YS_YS");
        createInspOrderDo.setInspOper(saleOrderDo.getCreateOperId());
        createInspOrderDo.setCreateOperId(saleOrderDo.getCreateOperId());
        createInspOrderDo.setCreateTime(new Date());
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        for (Long contactId : contactAddressMap.keySet()) {
            Long shipOrderId = IdUtil.nextId();
            UocShipOrderDo createShipOrderDo = new UocShipOrderDo();
            createShipOrderDo.setShipOrderState("FH_FH_YS");
            createShipOrderDo.setShipOperId(saleOrderDo.getCreateOperId());
            createShipOrderDo.setCreateOperId(saleOrderDo.getCreateOperId());
            createShipOrderDo.setCreateTime(new Date());
            createShipOrderDo.setShipOrderId(shipOrderId);
            createShipOrderDo.setSupNo(saleOrderDo.getSaleOrderItems().get(0).getSupplierId());
            createShipOrderDo.setShipOrderNo(this.getShipOrderNo());
            UocShipInspRel createShipInspRel = new UocShipInspRel();
            createShipInspRel.setId(IdUtil.nextId());
            createShipInspRel.setShipOrderId(shipOrderId);
            createShipInspRel.setInspOrderId(createInspOrderDo.getInspOrderId());
            createShipInspRel.setOrderId(saleOrderDo.getOrderId());
            createShipInspRel.setSaleOrderId(saleOrderDo.getSaleOrderId());
            createShipInspRel.setCreateOperId(saleOrderDo.getCreateOperId());
            createShipInspRel.setCreateTime(new Date());
            uocShipInspRelList.add(createShipInspRel);
            ArrayList<UocShipOrderItem> shipOrderItemBoList = new ArrayList<UocShipOrderItem>();
            for (UocSaleItemShipAdress bo : contactAddressMap.get(contactId)) {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)((Object)saleOrderItemMap.get(bo.getSaleOrderItemId()));
                uocShipOrderItem.setShipOrderId(shipOrderId);
                uocShipOrderItem.setOrderId(saleOrderDo.getOrderId());
                uocShipOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocShipOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
                uocShipOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
                uocShipOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
                uocShipOrderItem.setCreateTime(new Date());
                uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
                uocShipOrderItem.setSendCount(bo.getShipCount());
                uocShipOrderItem.setInspCount(bo.getShipCount());
                shipOrderItemBoList.add(uocShipOrderItem);
                UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
                createInspOrderItem.setOrderId(saleOrderDo.getOrderId());
                createInspOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
                createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
                createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                createInspOrderItem.setInspCount(uocShipOrderItem.getInspCount());
                createInspOrderItem.setRemainInspCount(BigDecimal.ZERO);
                createInspOrderItem.setInitInspCount(uocShipOrderItem.getInspCount());
                createInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                createInspOrderItem.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
                createInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
                createInspOrderItem.setCreateTime(new Date());
                createInspOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
                createInspOrderItem.setChngingCount(BigDecimal.ZERO);
                uocInspOrderItemList.add(createInspOrderItem);
            }
            createShipOrderDo.setShipOrderItemBoList(shipOrderItemBoList);
            shipOrderList.add(createShipOrderDo);
            createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
            createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        }
        saleOrderDo.setShipOrderList(shipOrderList);
        saleOrderDo.setUocInspOrderDo(createInspOrderDo);
        for (UocSaleOrderItem bo : saleOrderDo.getSaleOrderItems()) {
            bo.setSendCount(bo.getPurchaseCount());
            bo.setAcceptanceCount(bo.getPurchaseCount());
        }
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(UocDicConstant.REL_TYPE.CH_INVOICE);
        createOrderRel.setOrderId(saleOrderDo.getOrderId());
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        saleOrderDo.setCreateOrderRel(createOrderRel);
    }

    private String getInspOrderNo() {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(UocDicConstant.ORDER_SOURCE.AGR_GENERATE);
        UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
        if (null != inspOrderNo) {
            return inspOrderNo.getInspOrderNo();
        }
        throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25");
    }

    private String getShipOrderNo() {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(UocDicConstant.ORDER_SOURCE.AGR_GENERATE);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if (null != uocShipOrderDo) {
            return uocShipOrderDo.getShipOrderNo();
        }
        throw new BaseBusinessException("101002", "\u751f\u6210\u53d1\u8d27\u5355\u7f16\u53f7\u5931\u8d25");
    }

    private void setSaleItemShipAddress(UocSaleOrderDo saleOrderDo) {
        ArrayList<UocSaleItemShipAdress> saleItemShipAdressList = new ArrayList<UocSaleItemShipAdress>();
        ArrayList<UocOrdLogisticsRela> receiveAddressList = new ArrayList<UocOrdLogisticsRela>();
        Map<Long, List<UocOrdLogisticsRela>> addressMap = saleOrderDo.getSaleOrderItems().stream().flatMap(bo -> bo.getAddressBoList().stream().map(address -> {
            UocOrdLogisticsRela uocOrdLogisticsRela = new UocOrdLogisticsRela();
            BeanUtils.copyProperties((Object)address, (Object)uocOrdLogisticsRela);
            uocOrdLogisticsRela.setOrderId(saleOrderDo.getOrderId());
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setCreateOperId(saleOrderDo.getCreateOperId());
            uocOrdLogisticsRela.setCreateTime(saleOrderDo.getCreateTime());
            return uocOrdLogisticsRela;
        })).collect(Collectors.groupingBy(UocOrdLogisticsRela::getUmcContactId));
        for (Long umcContactId : addressMap.keySet()) {
            receiveAddressList.add(addressMap.get(umcContactId).get(0));
        }
        saleOrderDo.setReceiveAddressList(receiveAddressList);
        for (UocSaleOrderItem saleOrderItem : saleOrderDo.getSaleOrderItems()) {
            for (UocCreateOrderServiceReqAddressBo saleOrderItemShipAdress : saleOrderItem.getAddressBoList()) {
                UocSaleItemShipAdress uocSaleItemShipAdress = new UocSaleItemShipAdress();
                uocSaleItemShipAdress.setSaleItemShipAdressId(IdUtil.nextId());
                uocSaleItemShipAdress.setOrderId(saleOrderDo.getOrderId());
                uocSaleItemShipAdress.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleItemShipAdress.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                uocSaleItemShipAdress.setShipCount(saleOrderItemShipAdress.getShipCount());
                uocSaleItemShipAdress.setContactId(addressMap.get(saleOrderItemShipAdress.getUmcContactId()).get(0).getContactId());
                uocSaleItemShipAdress.setCreateTime(saleOrderDo.getCreateTime());
                uocSaleItemShipAdress.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleItemShipAdress.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                saleItemShipAdressList.add(uocSaleItemShipAdress);
            }
        }
        saleOrderDo.setSaleItemShipAdressList(saleItemShipAdressList);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)((Object)saleOrderDo))) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        ArrayList<UocSaleOrderItem> allSaleOrderItems = new ArrayList<UocSaleOrderItem>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setBargainingId(saleOrderDo.getBargainingId());
            saleOrderItem.setBargainingNo(saleOrderDo.getBargainingNo());
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));
            saleOrderItem.setSaleFee(saleOrderItem.getSalePrice().multiply(saleOrderItem.getPurchaseCount()));
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }
            allSaleOrderItems.add(saleOrderItem);
            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (ObjectUtil.isNotEmpty(saleItemMapList)) {
                for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                    uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }
            if (!UocConstant.ItemType.COMB.equals(saleOrderItem.getItemType())) continue;
            for (UocSaleOrderItem subSaleInfoBo : saleOrderItem.getSubCommodityBos()) {
                UocSaleOrderItem subSaleOrderItem = new UocSaleOrderItem();
                BeanUtils.copyProperties((Object)((Object)subSaleInfoBo), (Object)((Object)subSaleOrderItem));
                subSaleOrderItem.setCombSaleItemId(saleOrderItem.getSaleOrderItemId());
                subSaleOrderItem.setOrderId(saleOrderDo.getOrderId());
                subSaleOrderItem.setSaleOrderItemId(IdUtil.nextId());
                subSaleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
                subSaleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
                subSaleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
                subSaleOrderItem.setPurchaseFee(subSaleOrderItem.getPurchasePrice().multiply(subSaleOrderItem.getPurchaseCount()));
                subSaleOrderItem.setSaleFee(subSaleOrderItem.getSalePrice().multiply(subSaleOrderItem.getPurchaseCount()));
                allSaleOrderItems.add(subSaleOrderItem);
            }
        }
        saleOrderDo.setSaleOrderItems(allSaleOrderItems);
    }

    private void setAfterTakeType(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            List<Integer> returnTypeList = saleOrderItem.getServerReturnTypeList();
            if (!ObjectUtil.isNotEmpty(returnTypeList)) continue;
            returnTypeList.forEach(e -> {
                UocSaleGoodsAfterTakeTypeBo afterTakeTypeBo = new UocSaleGoodsAfterTakeTypeBo();
                afterTakeTypeBo.setAfterTakeType((Integer)e);
                afterTakeTypeBo.setAfterTakeId(IdUtil.nextId());
                afterTakeTypeBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                afterTakeTypeBo.setCommodityId(saleOrderItem.getCommodityId());
                this.uocSaleOrderRepository.insertCommityAfterTakeType(afterTakeTypeBo);
            });
        }
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemIds)) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355\u660e\u7ec6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemListByItemIds(itemIds);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return this.uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)((Object)uocSaleOrderDo))) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        this.uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return this.uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return this.uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return this.uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        this.uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }

    @Override
    public UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.getSaleOrderStakeholder(qryBo);
    }

    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        return this.uocCommonRepository.getOrderNoSingle("SALE_ORDER_NO_" + saleOrderDo.getOrderSource());
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.addSaleOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    @Override
    public UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocOrderAgreementQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocOrderAgreementQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qryTotalFeeAndCount(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderItemQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        this.valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemSendCount(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        this.valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocImplOrderItem.getArrivalTime()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5230\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemArrivalTime(convertSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getCollectCount(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        uocSaleOrderDo.getSaleOrderItems().forEach(uocSaleOrderItem -> {
            if (null == uocSaleOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocSaleOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemInspCount(uocSaleOrderDo);
    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo.getStakeholder()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u4e09\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uocSaleOrderDo.getStakeholder().getOrderId() == null) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderStakeholder(uocSaleOrderDo);
    }

    @Override
    public void modifySalePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        this.valSaleItem(uocSaleOrderItem);
        this.uocSaleOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemChngingCount(convertImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemReturnCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    @Override
    public void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.batchModifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    private void valSaleItem(UocSaleOrderItem uocSaleOrderItem) {
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getSaleOrderItemId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo saleOrderDo) {
        this.deleteSaleOrderValDo(saleOrderDo);
        this.uocSaleOrderRepository.deleteSaleOrder(saleOrderDo);
    }

    @Override
    public void updateProcInst(UocOrderProcInst uocOrderProcInst) {
        this.uocCommonRepository.updateProInst(uocOrderProcInst);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        this.uocCommonRepository.updateTaskInst(uocOrderTaskInst);
    }

    private void deleteSaleOrderValDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyInspSuper(uocSaleOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemRefuseCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemArriveCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        this.validateUpdateSaleItemWithOutSkuId(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateItem(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.updateItemArriveAccount(uocSaleOrderDo);
    }

    @Override
    public void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    private void validateUpdateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (ObjectUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItems]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (saleOrderItem == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItem]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSkuExtSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getNakedPrice())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getTax())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)saleOrderItem.getTaxPrice())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmAdd(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirmAdd(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmReduce(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirmReduce(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderList(uocSaleOrderQryBo);
    }

    @Override
    public List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo convertSaleOrderDo) {
        return this.uocSaleOrderRepository.cancelEsOrderList(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrders(uocSaleOrderQryBo);
    }

    @Override
    public Integer qrySaleCounts(UocSaleOrderDo uocSaleOrderDo) {
        return this.uocSaleOrderRepository.qrySaleOrderCounts(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo) {
        return this.uocSaleOrderRepository.qryCommityTakeTypes(takeTypeBo);
    }

    @Override
    public List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record) {
        return this.uocSaleOrderRepository.selectSaleOrderItemPlan(record);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderListByBar(uocSaleOrderQryBo);
    }

    @Override
    public void batchSyncSale() {
        this.uocSaleOrderRepository.batchSyncSale();
    }

    @Override
    public List<UocSaleItemShipAdress> getSaleItemShipAdressList(UocSaleItemShipAdress uocSaleItemShipAdress) {
        return this.uocSaleOrderRepository.getSaleItemShipAdressList(uocSaleItemShipAdress);
    }
}

