package com.tydic.dyc.oc.model.shiporder;

import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrder
 * 说明:发货单
 * 时间:2022-02-21 14:31
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShipOrderDo implements Serializable {
    private static final long serialVersionUID = 546206669473986270L;

    //发货单id")
    private Long shipOrderId;

    //允许变更时限")
    private Date allowChngTime;

    //销售单id")
    private Long saleOrderId;

    //订单id")
    private Long orderId;

    //发货单编码")
    private String shipOrderNo;

    //外部发货单编码")
    private String shipOrderNoExt;

    //发货单名称")
    private String shipOrderName;

    //发货单类型")
    private Integer shipOrderType;

    //发货单状态")
    private String shipOrderState;

    //供应商编码")
    private String supNo;

    //供应商账户")
    private String supAccount;

    //物流公司id")
    private String shipCompanyId;

    //物流公司名称")
    private String shipCompanyName;

    //物流单号")
    private String shipCompanyNo;

    //车牌号")
    private String carNo;

    //运输方式")
    private Integer transportMode;

    //运输方式翻译")
    private String transportModeStr;

    //发货时间")
    private Date shipTime;

    //发货联系人姓名")
    private String shipName;

    //发货联系人电话")
    private String shipPhone;

    //发货工号")
    private String shipOperId;

    //预计到货时间")
    private Date estimateArrivalTime;

    //到货时间")
    private Date arriveTime;

    //验收时间-该发货单全部被验收")
    private Date inspTime;

    //验收人名称")
    private String inspOperName;

    //验收人工号")
    private String inspOperId;

    //验收人电话")
    private String inspOperPhone;


    //发货备注")
    private String shipRemark;

    //到货备注")
    private String arriveRemark;

    //收/拒收 货人")
    private String receiverUser;

    //收/拒收 货备注")
    private String receiverRemark;

    //收/拒收 联系人")
    private String receiverContact;

    //收/拒收 时间")
    private Date receiverTime;

    //是否可以异常变更：1：不允许；其他情况都可以")
    private Integer isAbnormal;

    //环节编码")
    private String procState;

    //竣工标志             1 竣工             0 在途")
    private Integer finishFlag;

    //租户ID")
    private String tenantId;

    //创建时间")
    private Date createTime;

    //创建工号")
    private String createOperId;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //撤单时间")
    private Date cancelTime;

    //撤单工号")
    private String cancelOperId;

    //撤单原因")
    private String cancelReason;

    //撤单标志:1 已撤单             0 未撤单")
    private Integer cancelFlag;

    //备注")
    private String remark;

    //竣工时间")
    private Date finishTime;

    //逾期时间")
    private Date expTime;

    //发货单扩展")
    private List<UocShipOrderMap> extParallelBoList;

    //发货单明细")
    private List<UocShipOrderItem> shipOrderItemBoList;

    //附件")
    private List<UocOrderAccessory> orderAccessoryBoList;

    //发货单IDList")
    private List<Long> shipOrderIdList;

    //发货单明细IDList")
    private List<Long> shipOrderItemIdList;

    //订单IDList")
    private List<Long> orderIdList;

    //订单来源  1 自营单品   2 电商导入   3 协议生成    ")
    private Integer orderSource;
    
    //到货时间开始")
    private Date arriveTimeStart;
    
    //到货时间结束")
    private Date arriveTimeEnd;
    //扩展字段1")
    private String extField1;

    //扩展字段2")
    private String extField2;

    //扩展字段3")
    private String extField3;

    //扩展字段4")
    private String extField4;

    //扩展字段5")
    private String extField5;
}
