package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocPreAuditReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocPreAuditRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述: 销售单预审
 *
 * @author : yuhao
 * @date : 2022/7/27 15:47
 */
@HTServiceImpl
@Slf4j
public class UocPreAuditServiceImpl implements UocPreAuditService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Override
    public UocPreAuditRspBO dealPreAudit(UocPreAuditReqBO reqBO) {
        UocPreAuditRspBO rspBO = new UocPreAuditRspBO();

        //更新销售单主体信息,供应商确认/拒单人，确认/拒单时间，拒单原因
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setOrderId(reqBO.getOrderId());
        updateUocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocSaleOrderDo.setRejectOperId(String.valueOf(reqBO.getUserId()));
        updateUocSaleOrderDo.setRejectOperName(reqBO.getName());
        updateUocSaleOrderDo.setRejectTime(new Date());
        updateUocSaleOrderDo.setRejectReason(reqBO.getRefuseReason());
        updateUocSaleOrderDo.setOrderManagerUserId(reqBO.getUserId().toString());
        updateUocSaleOrderDo.setOrderManagerUserName(reqBO.getName());
        updateUocSaleOrderDo.setOrderManagerContactPhone(reqBO.getRegMobileIn());
        updateUocSaleOrderDo.setOrderManagerCompanyId(reqBO.getCompanyId().toString());
        updateUocSaleOrderDo.setOrderManagerCompanyName(reqBO.getCompanyName());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);

        //提交任务
        this.commitTask(reqBO);

        //查询销售单，用于回退预算
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBO, UocSaleOrderQryBo.class);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBO.setSaleOrderId(saleOrderMainInfo.getSaleOrderId());
        rspBO.setSaleOrderNo(saleOrderMainInfo.getSaleOrderNo());
        rspBO.setBudgetId(saleOrderMainInfo.getBudgetId());
        rspBO.setPurCompanyId(saleOrderMainInfo.getStakeholder().getPurCompanyId());
        rspBO.setSupplierId(saleOrderMainInfo.getStakeholder().getSupId());

        //查询销售明细，用于回退预算
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBO, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        //销售单明细
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = UocRu.jsl(saleOrderItemList.stream().filter(bo -> !UocConstant.ItemType.COMB.equals(bo.getItemType())).collect(Collectors.toList()), UocGetSaleOrderDetailServiceRspItemBo.class);
        rspBO.setAgreementId(saleOrderItemList.get(0).getAgreementId());
        rspBO.setUocGetSaleOrderDetailServiceRspItemBos(uocGetSaleOrderDetailServiceRspItemBos);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 提交任务
     * @param reqBO
     */
    private void commitTask(UocPreAuditReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }
}
