package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
@Slf4j
@Component
public class UocCreateOrderProcInsUpdateStatusDomainServiceTransaction {
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCreateOrderProcInsUpdateStatusDomainServiceRspBo createOrderProcIns(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        log.info("订单处理任务数据入参：{}", JSON.toJSONString(reqBo));
        UocCommonDo uocCommonDo = UocRu.js(reqBo, UocCommonDo.class);
        UocCommonDo uocCommonDoRsp = this.iUocCommonModel.dealTask(uocCommonDo);
        UocCreateOrderProcInsUpdateStatusDomainServiceRspBo rspBo =
                UocRu.success(UocCreateOrderProcInsUpdateStatusDomainServiceRspBo.class);
        rspBo.setFinishTaskInfoBos(uocCommonDoRsp.getFinishTaskInfoBos());
        /*if (!CollectionUtils.isEmpty(reqBo.getNextTaskInfos())) {
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setSaleOrderId(reqBo.getNextTaskInfos().get(0).getBusiObjId());
        }*/
        rspBo.setSyncSaleOrderList(uocCommonDoRsp.getSyncSaleOrderList());
        rspBo.setSyncChngOrderList(uocCommonDoRsp.getSyncChngOrderList());
        rspBo.setSyncShipOrderList(uocCommonDoRsp.getSyncShipOrderList());
        rspBo.setSyncInspOrderList(uocCommonDoRsp.getSyncInspOrderList());
        rspBo.setSyncAfterOrderList(uocCommonDoRsp.getSyncAfterOrderList());
        rspBo.setSaleOrderId(uocCommonDoRsp.getSaleOrderId());
        rspBo.setSaleOrderNo(uocCommonDoRsp.getSaleOrderNo());
        rspBo.setBudgetId(uocCommonDoRsp.getBudgetId());
        rspBo.setPurCompanyId(uocCommonDoRsp.getPurCompanyId());
        rspBo.setSupplierId(uocCommonDoRsp.getSupplierId());
        rspBo.setAgreementId(uocCommonDoRsp.getAgreementId());
        rspBo.setUocGetSaleOrderDetailServiceRspItemBos(uocCommonDoRsp.getUocGetSaleOrderDetailServiceRspItemBos());

        return rspBo;
    }
}
