package com.tydic.dyc.oc.model.bargaining.sub;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author DUM
 * @date 2023/8/11
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocBargainingQuotationItem implements Serializable {

    /**
     * 报价明细ID
     */
    private Long quotationItemId;
    private Long quotationId;
    /**
     * 议价单明细id
     */
    private Long bargainingItemId;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     *期望价格
     */
    private BigDecimal expectPrice;
    /**
     * 报价（来源：报价单查询接口）
     */
    private BigDecimal confirmedPrice;
    /**
     * 差异率
     */
    private BigDecimal discountRate;
    /**
     * 专属报价小计,报价*报价数量
     */
    private BigDecimal confirmedPriceSub;
    /**
     * 备注
     */
    private String remark;
    /**
     * 扩展字段1
     */
    private String extField1;
    /**
     * 扩展字段2
     */
    private String extField2;
    /**
     * 扩展字段3
     */
    private String extField3;
    /**
     * 扩展字段4
     */
    private String extField4;
    /**
     * 扩展字段5
     */
    private String extField5;
    /**
     * 报价商品编码
     */
    private Long skuId;

    /** 以下参数来源与电商接口 **/
    /**
     * 外部单品ID(接口返回)
     */
    private String extSkuId;
    /**
     * 是	报价商品名称（来源：报价单查询接口）
     */
    private String skuName;
    /**
     * 是	报价商品数量（来源：报价单查询接口）
     */
    private Integer skuNum;
    /**
     * 否	报价品牌（来源：报价单查询接口）
     */
    private String confirmedBrandName;
    /**
     * 	否	报价型号（来源：报价单查询接口）
     */
    private String confirmedModel;
    /**
     * 	否	税率（来源：报价单查询接口）
     */
    private String taxRate;
    /**
     * 否	未税价（来源：报价单查询接口）
     */
    private BigDecimal nakedPrice;
    /**
     * 否	税价（来源：报价单查询接口）
     */
    private BigDecimal taxPrice;
    /**
     * 否	是否为环保产品（来源：报价单查询接口）
     */
    private Integer greenFlag;
    /**
     * 否	是否环保产品描述（来源：报价单查询接口）
     */
    private String greenFlagDesc;
    /**
     * 否	是否为小微企业（来源：报价单查询接口）
     */
    private Integer microCompanyFlag;
    /**
     * 	否	是否为小微企业描述（来源：报价单查询接口）
     */
    private String microCompanyFlagDesc;


}
