package com.tydic.dyc.oc.service.bargaining;


import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @author DUM
 * @date 2023/8/7
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocCancelBargainingServiceImpl implements UocCancelBargainingService{
    @Autowired
    private UocCancelBargainingTransaction uocCancelBargainingTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocCancelBargainingRspBo cancelBargaining(UocCancelBargainingReqBo uocCancelBargainingReqBo) {
        UocCancelBargainingRspBo rspBo = uocCancelBargainingTransaction.cancelBargaining(uocCancelBargainingReqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(uocCancelBargainingReqBo, rspBo);
        }
        return rspBo;
    }
    /**
     * 同步 Es
     **/
    private void syncEs(UocCancelBargainingReqBo reqBo, UocCancelBargainingRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getBargainingIndex());
        orderBo.setOrderId(reqBo.getBargainingId());
        orderBo.setObjId(reqBo.getBargainingId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
