package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocOutLogSaveDo;
import com.tydic.dyc.oc.service.common.bo.UocOutLogSaveServiceReqBo;
import com.tydic.dyc.oc.service.common.bo.UocOutLogSaveServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题:UocOutLogSaveServiceImpl
 * 说明:
 * 时间:2023/7/25 9:14
 * 作者:田桂银
 */
@HTServiceImpl
public class UocOutLogSaveServiceImpl implements UocOutLogSaveService {
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocOutLogSaveServiceRspBo saveOutLog(UocOutLogSaveServiceReqBo reqBo) {
        validateArg(reqBo);
        UocOutLogSaveDo saveDo = new UocOutLogSaveDo();
        BeanUtils.copyProperties(reqBo, saveDo);
        saveDo.setLogId(IdUtil.nextId());
        saveDo.setCreateTimeInner(new Date());
        iUocCommonModel.saveOutLog(saveDo);
        UocOutLogSaveServiceRspBo rspBo = UocRu.success(UocOutLogSaveServiceRspBo.class);
        rspBo.setLogId(saveDo.getLogId());
        return rspBo;
    }

    private void validateArg(UocOutLogSaveServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "参数不能为空");
        }
        if (reqBo.getSystemType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "系统类型不能为空");
        }
        if (reqBo.getLogType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "日志方向不能为空");
        }
        if (reqBo.getLogFlag() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "日志类型不能为空");
        }
        if (reqBo.getPartitionObjId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "分库键对象id不能为空");
        }
        if (reqBo.getBusiObjId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "业务对象id不能为空");
        }
        if (reqBo.getBusiObjType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "业务对象类型不能为空");
        }
//        if (reqBo.getBusiType() == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "业务场景类型不能为空");
//        }
//        if (reqBo.getSendService() == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发起调用服务类不能为空");
//        }
//        if (reqBo.getCallService() == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "被调用服务类不能为空");
//        }
        if (reqBo.getReqParam() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getCreateTime() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "外部业务创建时间不能为空");
        }
    }

}


