package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-取消销售单并终止订单流程实现〉
 * @author : yuhao
 * @date : 2022/7/20 18:05
 */
@Component
@Slf4j
public class UocCancelSaleOrderAndStopProcessTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Value("${delApprovalObjFlag:false}")
    private boolean delApprovalObjFlag;
    /**
     * 取消销售单并终止订单流程
     *
     * @param reqBO
     * @return
     */
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCancelSaleOrderAndStopProcessServiceRspBO cancelSaleOrderAndStopProcess(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocCancelSaleOrderAndStopProcessServiceRspBO rspBO = UocRu.success(UocCancelSaleOrderAndStopProcessServiceRspBO.class);
        rspBO.setSaleOrderState("");
        //参数校验
        this.verifyParam(reqBO);
        //更新销售单的状态
        this.updateSaleOrderStatus(reqBO, rspBO);
        //保存取消附件
        if(!CollectionUtils.isEmpty(reqBO.getOrderAccessoryBoList())){
            this.saveCancelAccessoryInfo(reqBO);
        }
        //更新销售单流程数据
        this.updateSaleOrderProcessInfo(reqBO);
        
        //查询是否有对应得审批单，并删除
        List<Long> auditOrderIdList = delApprovalObj(reqBO);
    
        rspBO.setAuditOrderIdList(auditOrderIdList);
        //返回结果
        return rspBO;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 删除对应得审批单对象表记录
     * @Date 15:33 2023/9/11
     * @Param [reqBO]
     * @return void
     */
    private List<Long> delApprovalObj(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        List<Long> auditOrderIdList = new ArrayList<>();
        if(delApprovalObjFlag){
            UocApprovalObjQryBo qryBo = new UocApprovalObjQryBo();
            qryBo.setOrderId(reqBO.getOrderId());
            qryBo.setObjId(String.valueOf(reqBO.getSaleOrderId()));
            List<UocApprovalObj> uocApprovalObjList =  iUocAuditOrderModel.qryApprovealObj(qryBo);
    
            if(ObjectUtil.isNotEmpty(uocApprovalObjList)){
                uocApprovalObjList.forEach(uocApprovalObj -> {
                    uocApprovalObj.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
                    UocApprovalObjQryBo uocApprovalObjQryBo = UocRu.js(uocApprovalObj,UocApprovalObjQryBo.class);
                    iUocAuditOrderModel.delApprovealObj(uocApprovalObjQryBo);
    
                    auditOrderIdList.add(uocApprovalObj.getAuditOrderId());
                });
                
                for (Long auditOrderId : auditOrderIdList){
    
                    UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo.setAuditOrderId(auditOrderId);
                    uocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
                    uocApprovalObjQryBo.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                    List<UocApprovalObj> uocApprovalObjList1 =  iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                    if(ObjectUtil.isEmpty(uocApprovalObjList1)){
                        UocAuditOrderDo uocAuditOrderDo = new UocAuditOrderDo();
                        uocAuditOrderDo.setAuditOrderId(auditOrderId);
                        uocAuditOrderDo.setAuditOrderStatus(UocStateConstants.AUDIT_PLUS_ORDER_STATUS.REVOKE);
                        iUocAuditOrderModel.updateApprove(uocAuditOrderDo);
                    }
                }
            }
            
        }
        return auditOrderIdList;
    }
    
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "订单id不能为空");
        }
        if(null == reqBO.getSaleOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "销售单id不能为空");
        }
    }

    /**
     * 更新销售单状态
     *
     * @param reqBO
     * @param rspBO
     */
    private void updateSaleOrderStatus(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO, UocCancelSaleOrderAndStopProcessServiceRspBO rspBO){
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateTime(new Date());
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setUpdateOperName(reqBO.getName());
        uocSaleOrderDo.setCancelTime(new Date());
        uocSaleOrderDo.setCancelReason(reqBO.getCancelReason());
        uocSaleOrderDo.setCancelReasonFlag(reqBO.getCancelReasonFlag());
        // 若为用户主动取消，进一步判断是否拒单后取消
        if (reqBO.getCancelReasonFlag() != null && reqBO.getCancelReasonFlag().equals(UocConstant.CancelReasonFlag.USER_CANCEL)) {
            UocSaleOrderDo qryDO = new UocSaleOrderDo();
            qryDO.setOrderId(reqBO.getOrderId());
            qryDO.setSaleOrderId(reqBO.getSaleOrderId());
            UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(qryDO);
            // 若为拒单待处理
            if(UocStateConstants.SaleOrder.XS_QR_JDDCL.equals(saleOrderMain.getSaleOrderState())){
                // 供应商主动取消
                uocSaleOrderDo.setCancelReasonFlag(UocConstant.CancelReasonFlag.VENDOR_CANCEL);
                rspBO.setSaleOrderState(UocStateConstants.SaleOrder.XS_QR_JDDCL);
            }
        }
        uocSaleOrderDo.setCancelOperName(reqBO.getName());
        uocSaleOrderDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }

    /**
     * 保存取消附件
     * @param reqBO
     */
    private void saveCancelAccessoryInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO){
        List<UocOrderAccessory> uocOrderAccessoryList =  new ArrayList<>();
        for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBO.getOrderAccessoryBoList()){
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setAccessoryId(uocBaseOrderAccessoryAddBo.getAccessoryId());
            uocOrderAccessory.setAccessoryName(uocBaseOrderAccessoryAddBo.getAccessoryName());
            uocOrderAccessory.setAccessoryUrl(uocBaseOrderAccessoryAddBo.getAccessoryUrl());
            uocOrderAccessory.setAttachmentType(uocBaseOrderAccessoryAddBo.getAttachmentType());
            uocOrderAccessory.setObjId(reqBO.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.CANCEL_SALE_ORDER);
            uocOrderAccessory.setOrderId(reqBO.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    /**
     * 更新销售单流程状态
     * @param reqBO
     */
    private void updateSaleOrderProcessInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO){
        UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
        uocOrderProcInst.setOrderId(reqBO.getOrderId());
        //uocOrderProcInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderProcInst.setObjId(reqBO.getSaleOrderId());
        uocOrderProcInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        uocOrderProcInst.setFinishTime(new Date());
        this.iUocSaleOrderModel.updateProcInst(uocOrderProcInst);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getSaleOrderId());
        //uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setDealOperId(reqBO.getUserId().toString());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealRemark("流程终止");
        this.iUocSaleOrderModel.updateTaskInst(uocOrderTaskInst);
    }
}
